-- Filename : wgenerator_SN54xx251.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
  use STD.TEXTIO.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_SYSTEM.all;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library SN54xx251;
  use SN54xx251.WAVES_DEVICE.all;
  use SN54xx251.WAVES_OBJECTS.all;
  use SN54xx251.WAVES_FRAMES.all;
  use SN54xx251.WAVES_UTILITIES.all;

package WGENERATOR_SN54xx251 is
  procedure SN54xx251_TEST
  (
    signal CONNECT   : inout Waves_Port_List
  );

  procedure SN54xx251_TEST
  (
    signal CONNECT            : inout Waves_Port_List;
    constant INPUT_FILE_NAME  : String;
    constant START_TOLERANCE  : Time;
    constant END_TOLERANCE    : Time 
  );

end WGENERATOR_SN54xx251;

-- ======================================================================

package body WGENERATOR_SN54xx251 is

  constant I_PINS : Pinset := NEW_PINSET(( TP_C, TP_B, TP_A,
                      TP_G, TP_D0, TP_D1, TP_D2, TP_D3, 
                      TP_D4, TP_D5, TP_D6, TP_D7));

  constant O_PINS : Pinset := ALL_PINS and not I_PINS;

  constant EMPTY_EVENT : Integer := -1;

  ---------------------------------------------------------------------------
  --  The following procedure is used to provide test vectors for the model.
  --  The test vectors (inputs and expected outputs) are contained within
  --  the procedure, and are analyzed with the VHDL code.  The test vectors
  --  are applied as follows:
  --
  --   Beginning of period:  Inputs set to appropriate values
  --                         Expected outputs set to "don't care"
  --
  --   After 95 ns (95% of period):  Expected outputs set to appropriate values
  --
  --   After 100 ns (end of period): Get next set of inputs and outputs
  ---------------------------------------------------------------------------
  procedure SN54xx251_TEST(
    signal CONNECT   : inout Waves_Port_List) is

    constant PERIOD          : Time       := 100 ns;
    constant UNCERTAINTY_PCT : Real       := 0.95;
    constant TDELAY          : Event_Time := ETIME (UNCERTAINTY_PCT * PERIOD);

    constant FSA : Frame_Set_Array := 
      NEW_FRAME_SET_ARRAY ( INPUT_FRAMES, I_PINS) +
      NEW_FRAME_SET_ARRAY ( STROBED_OUTPUT_FRAMES(TDELAY), O_PINS);

    constant DT_BASIS : Delay_Time_Basis := (FALSE, 0 ns, 0 ns,
                                             TIMED_DELAY,0, 0, 0);

    variable TD1 : Time_Data := NEW_TIME_DATA ( FSA );
    variable T1  : Wave_Timing := ((PERIOD, DT_BASIS), TD1);

    --        Order of signals:
    --
    --        (Y, W,
    --         C, B, A, G, D0, D1, D2, D3, D4, D5, D6, D7)
    --

   variable ALL_STATES_D0 : Wtime_Slice_List (1 to 11) := (
      (  "UU"
     & "UUUUUUUUUUUU", T1),

      (  "01"
     & "000000000000", T1), -- reset

      (  "UU"
     & "0000U0000000", T1),

      (  "XX"
     & "0000X0000000", T1),

      (  "01"
     & "000000000000", T1),

      (  "10"
     & "000010000000", T1),

      (  "XX"
     & "0000Z0000000", T1),

      (  "XX"
     & "0000W0000000", T1),

      (  "01"
     & "0000L0000000", T1),

      (  "10"
     & "0000H0000000", T1),

      (  "XX"
     & "0000-0000000", T1)
      );



    variable ALL_STATES_D1 : Wtime_Slice_List (1 to 10) := (
      (  "01"
     & "000000000000", T1), -- reset

      (  "UU"
     & "00100U000000", T1),

      (  "XX"
     & "00100X000000", T1),

      (  "01"
     & "001000000000", T1),

      (  "10"
     & "001001000000", T1),

      (  "XX"
     & "00100Z000000", T1),

      (  "XX"
     & "00100W000000", T1),

      (  "01"
     & "00100L000000", T1),

      (  "10"
     & "00100H000000", T1),

      (  "XX"
     & "00100-000000", T1)
      );



    variable ALL_STATES_D2 : Wtime_Slice_List (1 to 10) := (
      (  "01"
     & "000000000000", T1), -- reset

      (  "UU"
     & "010000U00000", T1),

      (  "XX"
     & "010000X00000", T1),

      (  "01"
     & "010000000000", T1),

      (  "10"
     & "010000100000", T1),

      (  "XX"
     & "010000Z00000", T1),

      (  "XX"
     & "010000W00000", T1),

      (  "01"
     & "010000L00000", T1),

      (  "10"
     & "010000H00000", T1),

      (  "XX"
     & "010000-00000", T1)
      );



    variable ALL_STATES_D3 : Wtime_Slice_List (1 to 10) := (
      (  "01"
     & "000000000000", T1), -- reset

      (  "UU"
     & "0110000U0000", T1),

      (  "XX"
     & "0110000X0000", T1),

      (  "01"
     & "011000000000", T1),

      (  "10"
     & "011000010000", T1),

      (  "XX"
     & "0110000Z0000", T1),

      (  "XX"
     & "0110000W0000", T1),

      (  "01"
     & "0110000L0000", T1),

      (  "10"
     & "0110000H0000", T1),

      (  "XX"
     & "0110000-0000", T1)
      );



    variable ALL_STATES_D4 : Wtime_Slice_List (1 to 10) := (
      (  "01"
     & "000000000000", T1), -- reset

      (  "UU"
     & "10000000U000", T1),

      (  "XX"
     & "10000000X000", T1),

      (  "01"
     & "100011110111", T1),

      (  "10"
     & "100000001000", T1),

      (  "XX"
     & "10000000Z000", T1),

      (  "XX"
     & "10000000W000", T1),

      (  "01"
     & "10001111L111", T1),

      (  "10"
     & "10000000H000", T1),

      (  "XX"
     & "10000000-000", T1)
      );



    variable ALL_STATES_D5 : Wtime_Slice_List (1 to 10) := (
      (  "01"
     & "000000000000", T1), -- reset

      (  "UU"
     & "101000000U00", T1),

      (  "XX"
     & "101000000X00", T1),

      (  "01"
     & "101000000000", T1),

      (  "10"
     & "101000000100", T1),

      (  "XX"
     & "101000000Z00", T1),

      (  "XX"
     & "101000000W00", T1),

      (  "01"
     & "101000000L00", T1),

      (  "10"
     & "101000000H00", T1),

      (  "XX"
     & "101000000-00", T1)
      );



    variable ALL_STATES_D6 : Wtime_Slice_List (1 to 10) := (
      (  "01"
     & "000000000000", T1), -- reset

      (  "UU"
     & "1100000000U0", T1),

      (  "XX"
     & "1100000000X0", T1),

      (  "01"
     & "110000000000", T1),

      (  "10"
     & "110000000010", T1),

      (  "XX"
     & "1100000000Z0", T1),

      (  "XX"
     & "1100000000W0", T1),

      (  "01"
     & "1100000000L0", T1),

      (  "10"
     & "1100000000H0", T1),

      (  "XX"
     & "1100000000-0", T1)
      );



    variable ALL_STATES_D7 : Wtime_Slice_List (1 to 10) := (
      (  "01"
     & "000000000000", T1), -- reset

      (  "UU"
     & "11100000000U", T1),

      (  "XX"
     & "11100000000X", T1),

      (  "01"
     & "111000000000", T1),

      (  "10"
     & "111000000001", T1),

      (  "XX"
     & "11100000000Z", T1),

      (  "XX"
     & "11100000000W", T1),

      (  "01"
     & "11100000000L", T1),

      (  "10"
     & "11100000000H", T1),

      (  "XX"
     & "11100000000-", T1)
      );



    variable ALL_STATES_SELECT_C : Wtime_Slice_List (1 to 10) := (
      (  "01"
     & "000000000000", T1), -- reset

      (  "UU"
     & "U00000000000", T1),

      (  "XX"
     & "X00000000000", T1),

      (  "01"
     & "000000000000", T1),

      (  "01"
     & "100000000000", T1),

      (  "XX"
     & "Z00000000000", T1),

      (  "XX"
     & "W00000000000", T1),

      (  "01"
     & "L00000000000", T1),

      (  "01"
     & "H00000000000", T1),

      (  "XX"
     & "-00000000000", T1)
      );



    variable ALL_STATES_SELECT_B : Wtime_Slice_List (1 to 10) := (
      (  "01"
     & "000000000000", T1), -- reset

      (  "UU"
     & "0U0000000000", T1),

      (  "XX"
     & "0X0000000000", T1),

      (  "01"
     & "000000000000", T1),

      (  "01"
     & "010000000000", T1),

      (  "XX"
     & "0Z0000000000", T1),

      (  "XX"
     & "0W0000000000", T1),

      (  "01"
     & "0L0000000000", T1),

      (  "01"
     & "0H0000000000", T1),

      (  "XX"
     & "0-0000000000", T1)
      );



    variable ALL_STATES_SELECT_A : Wtime_Slice_List (1 to 10) := (
      (  "01"
     & "000000000000", T1), -- reset

      (  "UU"
     & "00U000000000", T1),

      (  "XX"
     & "00X000000000", T1),

      (  "01"
     & "000000000000", T1),

      (  "01"
     & "001000000000", T1),

      (  "XX"
     & "00Z000000000", T1),

      (  "XX"
     & "00W000000000", T1),

      (  "01"
     & "00L000000000", T1),

      (  "01"
     & "00H000000000", T1),

      (  "XX"
     & "00-000000000", T1)
      );



    variable TIMING_PARAMS : Wtime_Slice_List (1 to 9) := (
      (  "01"
     & "000001XXXXXX", T1), -- reset

      (  "ZZ"
     & "000101XXXXXX", T1), -- tplz_g_y  & tphz_g_w

      (  "01"
     & "000001XXXXXX", T1), -- tpzl_g_y  & tpzh_g_w

      (  "10"
     & "001001XXXXXX", T1), -- tplh_bs_y & tphl_bs_w

      (  "01"
     & "000001XXXXXX", T1), -- tphl_bs_y & tpls_bs_w

      (  "10"
     & "000010XXXXXX", T1), -- tplh_d_y  & tphl_d_w

      (  "ZZ"
     & "000110XXXXXX", T1), -- tphz_g_y  & tplz_g_w

      (  "10"
     & "000010XXXXXX", T1), -- tpzh_g_y  & tpzl_g_w

      (  "01"
     & "000000XXXXXX", T1) -- tphl_d_y  & tplh_d_w
      );



    variable TRUTH_TABLE : Wtime_Slice_List (1 to 18) := (
      (  "01"
     & "000000000000", T1),-- reset

      (  "ZZ"
     & "XXX1XXXXXXXX", T1),

      (  "01"
     & "00000XXXXXXX", T1),

      (  "10"
     & "00001XXXXXXX", T1),

      (  "01"
     & "0010X0XXXXXX", T1),

      (  "10"
     & "0010X1XXXXXX", T1),

      (  "01"
     & "0100XX0XXXXX", T1),

      (  "10"
     & "0100XX1XXXXX", T1),

      (  "01"
     & "0110XXX0XXXX", T1),

      (  "10"
     & "0110XXX1XXXX", T1),

      (  "01"
     & "1000XXXX0XXX", T1),

      (  "10"
     & "1000XXXX1XXX", T1),

      (  "01"
     & "1010XXXXX0XX", T1),

      (  "10"
     & "1010XXXXX1XX", T1),

      (  "01"
     & "1100XXXXXX0X", T1),

      (  "10"
     & "1100XXXXXX1X", T1),

      (  "01"
     & "1110XXXXXXX0", T1),

      (  "10"
     & "1110XXXXXXX1", T1)
      );



  begin
    assert FALSE
      report "ALL_STATES_D0 vectors"
        severity note;
      for I in ALL_STATES_D0' range loop
        APPLY(CONNECT,ALL_STATES_D0(I).CODES,ALL_STATES_D0(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_D1 vectors"
        severity note;
      for I in ALL_STATES_D1' range loop
        APPLY(CONNECT,ALL_STATES_D1(I).CODES,ALL_STATES_D1(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_D2 vectors"
        severity note;
      for I in ALL_STATES_D2' range loop
        APPLY(CONNECT,ALL_STATES_D2(I).CODES,ALL_STATES_D2(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_D3 vectors"
        severity note;
      for I in ALL_STATES_D3' range loop
        APPLY(CONNECT,ALL_STATES_D3(I).CODES,ALL_STATES_D3(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_D4 vectors"
        severity note;
      for I in ALL_STATES_D4' range loop
        APPLY(CONNECT,ALL_STATES_D4(I).CODES,ALL_STATES_D4(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_D5 vectors"
        severity note;
      for I in ALL_STATES_D5' range loop
        APPLY(CONNECT,ALL_STATES_D5(I).CODES,ALL_STATES_D5(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_D6 vectors"
        severity note;
      for I in ALL_STATES_D6' range loop
        APPLY(CONNECT,ALL_STATES_D6(I).CODES,ALL_STATES_D6(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_D7 vectors"
        severity note;
      for I in ALL_STATES_D7' range loop
        APPLY(CONNECT,ALL_STATES_D7(I).CODES,ALL_STATES_D7(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_SELECT_C vectors"
        severity note;
      for I in ALL_STATES_SELECT_C' range loop
        APPLY(CONNECT,ALL_STATES_SELECT_C(I).CODES,ALL_STATES_SELECT_C(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_SELECT_B vectors"
        severity note;
      for I in ALL_STATES_SELECT_B' range loop
        APPLY(CONNECT,ALL_STATES_SELECT_B(I).CODES,ALL_STATES_SELECT_B(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_SELECT_A vectors"
        severity note;
      for I in ALL_STATES_SELECT_A' range loop
        APPLY(CONNECT,ALL_STATES_SELECT_A(I).CODES,ALL_STATES_SELECT_A(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "TIMING_PARAMS vectors"
        severity note;
      for I in TIMING_PARAMS' range loop
        APPLY(CONNECT,TIMING_PARAMS(I).CODES,TIMING_PARAMS(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "TRUTH_TABLE vectors"
        severity note;
      for I in TRUTH_TABLE' range loop
        APPLY(CONNECT,TRUTH_TABLE(I).CODES,TRUTH_TABLE(I).WTIME,ALL_PINS);
      end loop;

    end;

  ---------------------------------------------------------------------------
  --  The following procedure is used to provide test vectors for the model.
  --  The test vectors (inputs and expected outputs, along with the period
  --  of each slice) are read in from an external file.  The test vectors 
  --  are applied as follows:
  --
  --   Beginning of period:  Inputs set to appropriate values
  --                         Expected outputs set to "don't care"
  --
  --   After <START_TOLERANCE>:  Expected outputs set to appropriate values
  --
  --   After <FS_TIME - END_TOLERANCE>: Get next set of inputs and outputs
  --
  --   After <FS_TIME> (end of period): Get next set of inputs and outputs
  ---------------------------------------------------------------------------
    procedure SN54xx251_Test
    (
      signal CONNECT   : inout Waves_Port_List;

      constant INPUT_FILE_NAME  : String;
      constant START_TOLERANCE  : Time;
      constant END_TOLERANCE    : Time ) is

      variable TOLERANCE : Time := START_TOLERANCE + END_TOLERANCE;

      constant FSA : Frame_Set_Array :=
          NEW_FRAME_SET_ARRAY (INPUT_FRAMES, I_PINS) +
          NEW_FRAME_SET_ARRAY (OUTPUT_FRAMES, O_PINS);

      constant DT_BASIS : Delay_Time_Basis := (FALSE, 0 ns, 0 ns,
                                               TIMED_DELAY, 0, 0, 0);

      variable TD : Time_Data := NEW_TIME_DATA (FSA);

      constant FSA_DONT_CARE : Frame_Set_Array :=
          NEW_FRAME_SET_ARRAY (INPUT_FRAMES, I_PINS) +
          NEW_FRAME_SET_ARRAY (DONT_CARE_FRAMES, O_PINS);

      variable TD_DONT_CARE : Time_Data := NEW_TIME_DATA (FSA_DONT_CARE);

      file INPUT_FILE : Text is in INPUT_FILE_NAME;

      -- the file slice must be allocated
      variable SN54xx251_FILE_SLICE : File_Slice := NEW_FILE_SLICE;

    begin
      loop
        READ_FILE_SLICE(INPUT_FILE, SN54xx251_FILE_SLICE);
        exit when SN54xx251_FILE_SLICE.END_OF_FILE;
        if SN54xx251_FILE_SLICE.FS_TIME > TOLERANCE then
          APPLY(CONNECT, SN54xx251_FILE_SLICE.CODES.all, 
                DELAY(START_TOLERANCE), TD_DONT_CARE);
          APPLY(CONNECT, SN54xx251_FILE_SLICE.CODES.all, 
                DELAY(SN54xx251_FILE_SLICE.FS_TIME - TOLERANCE), TD);
          APPLY(CONNECT, SN54xx251_FILE_SLICE.CODES.all, 
                DELAY(END_TOLERANCE), TD_DONT_CARE);
        else
          APPLY(CONNECT, SN54xx251_FILE_SLICE.CODES.all, 
                DELAY(SN54xx251_FILE_SLICE.FS_TIME), TD);
        end if;
      end loop;
    end;
end WGENERATOR_SN54xx251;
