-- Filename : waves_device_SN54xx251.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is ( TP_Y, TP_W, TP_STR, TP_A, TP_B, TP_C,
                      TP_D0, TP_D1, TP_D2, TP_D3, 
                      TP_D4, TP_D5, TP_D6, TP_D7);


  constant DEVICE_ID : String := "SN54xx251";

  -- The following declaration is just for documentation purposes.

  constant PIN_DIRECTION : Direction_List := (Response,   -- TP_Y
                                              Response,   -- TP_W
                                              Stimulus,   -- TP_STR
                                              Stimulus,   -- TP_A
                                              Stimulus,   -- TP_B
                                              Stimulus,   -- TP_C
                                              Stimulus,   -- TP_D0
                                              Stimulus,   -- TP_D1
                                              Stimulus,   -- TP_D2
                                              Stimulus,   -- TP_D3
                                              Stimulus,   -- TP_D4
                                              Stimulus,   -- TP_D5
                                              Stimulus,   -- TP_D6
                                              Stimulus);   -- TP_D7)
        
  function PIN_NAME (PIN : Test_Pins) return String;
    
end WAVES_DEVICE;

-- ======================================================================

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is ( TP_Y, TP_W, TP_C, TP_B, TP_A,
                      TP_G, TP_D0, TP_D1, TP_D2, TP_D3, 
                      TP_D4, TP_D5, TP_D6, TP_D7);

  constant DEVICE_ID : String := "SN54xx251";

  -- The following declaration is just for documentation purposes.

  constant PIN_DIRECTION : Direction_List := (Response,   -- TP_Y
                                              Response,   -- TP_W
                                              Stimulus,   -- TP_G
                                              Stimulus,   -- TP_C
                                              Stimulus,   -- TP_B
                                              Stimulus,   -- TP_A
                                              Stimulus,   -- TP_D0
                                              Stimulus,   -- TP_D1
                                              Stimulus,   -- TP_D2
                                              Stimulus,   -- TP_D3
                                              Stimulus,   -- TP_D4
                                              Stimulus,   -- TP_D5
                                              Stimulus,   -- TP_D6
                                              Stimulus);   -- TP_D7)
        
  function PIN_NAME (PIN : Test_Pins) return String;
    
end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_Y => return "Y";
      when TP_W => return "W";
      when TP_G => return "G";
      when TP_A => return "A";
      when TP_B => return "B";
      when TP_C => return "C";
      when TP_D0 => return "D0";
      when TP_D1 => return "D1";
      when TP_D2 => return "D2";
      when TP_D3 => return "D3";
      when TP_D4 => return "D4";
      when TP_D5 => return "D5";
      when TP_D6 => return "D6";
      when TP_D7 => return "D7";
    end case;
  end;
end WAVES_DEVICE;




