-- Filename : SN54xx251_TB_CON.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library STD_PACK;
  use STD_PACK.SIMFLAG.all;    -- Global simulation options
  use STD_PACK.TTL_TIMING.all; -- TTL derating coefficients

library SN54xx251;
  use SN54xx251.SN54xx251_TIMING.all;  -- timing module


configuration SN54xx251_TB_CON of SN54xx251_TB is

for TEST_BENCH
  for UNDER_TEST : DUT use entity SN54xx251.SN54xx251_DIP16(STRUCTURAL)
    generic map (
      DIP_TIME_MODE => TYPICAL,      -- MIN, TYP, or MAX
      DIP_FAMILY    => STD_FAMILY,   -- STD, S, or LS
      DIP_VCC       => 5.0,          -- Volts
      DIP_TA        => 25.0,         -- degrees Celsius
      DIP_DFACTOR   => 100.0,        -- percent
      DIP_REF       => "SN54xx251",  -- component reference designator

      TWD_G   => 0 ns,   -- back-annotated input wire delays
      TWD_A   => 0 ns,
      TWD_B   => 0 ns,
      TWD_C   => 0 ns,
      TWD_D0  => 0 ns,
      TWD_D1  => 0 ns,
      TWD_D2  => 0 ns,
      TWD_D3  => 0 ns,
      TWD_D4  => 0 ns,
      TWD_D5  => 0 ns,
      TWD_D6  => 0 ns,
      TWD_D7  => 0 ns,

      CL_Y   => 50.0,   -- back-annotated output loading (picofarads)
      CL_W   => 50.0    -- (timing module will adjust time accordingly)
    );

  end for;
end for;        

end SN54xx251_TB_CON;
