-- Filename : SN54xx251_TB.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library SN54xx251;
  use SN54xx251.WAVES_DEVICE.all;
  use SN54xx251.WAVES_OBJECTS.all;
  use SN54xx251.WAVES_UTILITIES.all;
  use SN54xx251.WGENERATOR_SN54xx251.all;

entity SN54xx251_TB is
  begin
end SN54xx251_TB;

-- ======================================================================

architecture TEST_BENCH of SN54xx251_TB is

  component DUT 
    port (Y, W : out Std_Ulogic;
          G, A, B, C, D0, D1, D2, D3, D4, D5, D6, D7 : in  Std_Ulogic );
  end component;

  subtype Test_Pin_Range is Integer range
    Test_Pins'pos(TP_Y) + 1 to Test_Pins'pos(TP_D7) + 1;

  -- Input and Output traffic of DUT
    signal TRAFFIC : Std_Ulogic_Vector(Test_Pin_Range);

  -- Test program options
  constant IN_FILE_NAME    : String := "SN54xx251_waves.dat";
  constant START_TOLERANCE : Time   := 2 ns;
  constant END_TOLERANCE   : Time   := 2 ns;

  -- Comparator options
  signal COMPARE          : Boolean           := TRUE;
  constant HOW_TO_REPORT  : Comparison_Format := DO_ASSERTION;
  constant ASSERTION_LEVEL : Severity_Level   := WARNING;

  -- Signal monitor options
  constant HOW_TO_PRINT  : Output_Format := STANDARD;
  constant OUT_FILE_NAME : String        := "SN54xx251_out.dat";

  -- signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) := (others.M_VALUE =>TRUE);
  signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range);

  -- Connection to WAVES dataset
  signal CONNECT : Waves_Port_List (Test_Pin_Range);

  subtype Compare_Pin_Range is Integer range
    Test_Pins'pos(TP_Y) + 1 to Test_Pins'pos(TP_W) + 1;

------------------------------------------------------------------------------

begin

  -- Call the waveform generator (i.e., the WAVES dataset)
  process begin
  --      SN54xx251_TEST(CONNECT, IN_FILE_NAME, START_TOLERANCE, END_TOLERANCE);
    SN54xx251_TEST(CONNECT);
    wait;
  end process;

----------------------------------------------------------------------------
  -- Instantiate the Device under test
  UNDER_TEST : DUT
    port map 
    (
      TRAFFIC(Test_Pins'pos(TP_Y) + 1),
      TRAFFIC(Test_Pins'pos(TP_W) + 1),
      TRAFFIC(Test_Pins'pos(TP_G) + 1),
      TRAFFIC(Test_Pins'pos(TP_A) + 1),
      TRAFFIC(Test_Pins'pos(TP_B) + 1),
      TRAFFIC(Test_Pins'pos(TP_C) + 1),
      TRAFFIC(Test_Pins'pos(TP_D0) + 1),
      TRAFFIC(Test_Pins'pos(TP_D1) + 1),
      TRAFFIC(Test_Pins'pos(TP_D2) + 1),
      TRAFFIC(Test_Pins'pos(TP_D3) + 1),
      TRAFFIC(Test_Pins'pos(TP_D4) + 1),
      TRAFFIC(Test_Pins'pos(TP_D5) + 1),
      TRAFFIC(Test_Pins'pos(TP_D6) + 1),
      TRAFFIC(Test_Pins'pos(TP_D7) + 1)
  );

----------------------------------------------------------------------------
  -- Collect all signals (inputs and output of DUT) into signal TRAFFIC

  COLLECT_INPUTS:
    for I in Test_Pins'pos(TP_C) + 1 to Test_Pins'pos(TP_D7) + 1 generate
       TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
       (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I)));
    end generate COLLECT_INPUTS;

----------------------------------------------------------------------------

  SIGNAL_TRAFFIC : SIGNAL_MONITOR(OUT_FILE_NAME, TRAFFIC, HOW_TO_PRINT);

----------------------------------------------------------------------------

  GEN_COMPARATOR:
    for I in Compare_Pin_Range generate
      COMPARATOR : CHECK_RESPONSE
      (
        WHICH_ONE => I,
        RESPONSE => TRAFFIC(I),
        PREDICTION => CONNECT(I),
        COMPARE => COMPARE,
        HOW_TO_REPORT => HOW_TO_REPORT,
        ASSERTION_LEVEL => ASSERTION_LEVEL,
        MATCH => SMATCH(I).M_VALUE 
      );
    end generate GEN_COMPARATOR;
end TEST_BENCH;






