-- Filename : SN54xx21_DIP14.vhd
--
-- Version 2.1
--
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--      
-- Part Name:          SN54xx21
-- Manufacturer:       Motorola, Texas Instruments
-- Other Sources:      National Semiconductor, Fairchild Semiconductor
-- Reference:          Data Sheet - The 1988 TTL Data Book (p. 2-103)
-- Packaging:          J Suffix (ceramic 14 pin DIP), or
--                     W Suffix (ceramic flat package)
--
-- Description:       The bipolar SSI SN54xx21 is a dual 4-input and gate.
--                    The '54 series meets military specifications.
--
-- Developer:         Institute for Technology Development
--                    VHDL Modeling Group
--                    1 Research Boulevard, Suite 205
--                    Starkville, MS 39759
--
-- Contact:           Dan Johnson
--                    CAD Section Manager
--                    (601) 325-2240
--                    danj@itd.msstate.edu
--
-- Version            2.1
-- Date:              07-12-91
--
-- Date of Formal
-- Verification:      TBD
--
--
--        ------------------------------------------------------------------
--
--
-- Recommended operating conditions:
--
--   STD_FAMILY is unavailable for this part.
--
--   S_FAMILY is unavailable for this part.
--
--   LS_FAMILY
--    _____________________________________________
--   |      |  minimum  nominal  maximum  |  unit  |
--   |______|_____________________________|________|
--   | VCC  |  4.5      5.0      5.5      | V      |
--   | VIH  |  2.0                        | V      |
--   | VIL  |                    0.7      | V      |
--   | IOH  |                   -0.4      | mA     |
--   | IOL  |                      4      | mA     |
--   | TA   | -55       25       125      | deg. C |
--   |______|_____________________________|________|
--
--
-- Worst case operating conditions:
--    _________________________________
--   |        | voltage   temperature  |
--   | _______|________________________|
--   | tphl   | 5.5 V     -55 deg. C   |
--   | tplh   | 4.5 V     125 deg. C   |
--   |________|________________________|
--
-- Note: High capacitive loading also degrades propagation delays of the part.

library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all ;   -- Defines logic types, operators, functions

library STD_PACK ;                  -- Standard library for all models
  use STD_PACK.SIMFLAG.all;         -- Global simulation options
  use STD_PACK.TTL_TIMING.all;      -- TTL derating coefficients

library SN54xx21;
  use SN54xx21.SN54xx21_timing.all; -- timing module

------------------------------------------------------------

entity SN54xx21_DIP14 is 

generic
  (
    DIP_TIME_MODE : Time_Modes := TYPICAL;
    DIP_FAMILY    : Tech_Type  := STD_FAMILY;
    DIP_VCC       : Real       := VCC;
    DIP_TA        : Real       := TA;
    DIP_DFACTOR   : Real       := DERATE_FACTOR;
    DIP_REF       : String     := "SN54xx21";

    TWD_A1  : Time := 0 ns;
    TWD_B1  : Time := 0 ns;
    TWD_C1  : Time := 0 ns;
    TWD_D1  : Time := 0 ns;
    TWD_A2  : Time := 0 ns;
    TWD_B2  : Time := 0 ns;
    TWD_C2  : Time := 0 ns;
    TWD_D2  : Time := 0 ns;

    CL_Y1   : Real := 15.0;  -- pf
    CL_Y2   : Real := 15.0  -- pf
  );

  port(

     Y1        : out Std_Ulogic ;
     Y2        : out Std_Ulogic ;
  
     A1        : in Std_Ulogic ;
     B1        : in Std_Ulogic ;
     C1        : in Std_Ulogic ;
     D1        : in Std_Ulogic ;
     A2        : in Std_Ulogic ;
     B2        : in Std_Ulogic ;
     C2        : in Std_Ulogic ;
     D2        : in Std_Ulogic ;

     VCC       : in Real := 5.0;  -- volts
     GND       : in Real := 0.0   -- volts

   ) ;

  -- pin mapping for J package

   attribute PIN_NO         : positive ;
   attribute PIN_NO of A1   : signal is 1 ;
   attribute PIN_NO of B1   : signal is 2 ;
   attribute PIN_NO of C1   : signal is 4 ;
   attribute PIN_NO of D1   : signal is 5 ;
   attribute PIN_NO of Y1   : signal is 6 ;
   attribute PIN_NO of GND  : signal is 7 ;
   attribute PIN_NO of Y2   : signal is 8 ;
   attribute PIN_NO of A2   : signal is 9 ;
   attribute PIN_NO of B2   : signal is 10 ;
   attribute PIN_NO of C2   : signal is 12 ;
   attribute PIN_NO of D2   : signal is 13 ;
   attribute PIN_NO of VCC  : signal is 14 ;

end SN54xx21_DIP14;

------------------------------------------------------------

architecture STRUCTURAL of SN54xx21_DIP14 is

  component ANDGATE

  generic
    (
     GEN_PROP_TIMES  : Prop_Times := GET_TIMING(DIP_FAMILY,
                                                DIP_TIME_MODE,
                                                DIP_VCC,
                                                DIP_TA,
                                                DIP_DFACTOR);
     GEN_FAMILY : Tech_Type := DIP_FAMILY;

     TWD_A : Time := 0.0 ns;    -- wire delays for each input pin
     TWD_B : Time := 0.0 ns;
     TWD_C : Time := 0.0 ns;
     TWD_D : Time := 0.0 ns;

     CL_Y : Real := 15.0;       -- fanout capacitance seen by output (in pf)

     REF : String := DIP_REF
);

port (
     Y        : out Std_Ulogic ;
     A        : in Std_Ulogic ;
     B        : in Std_Ulogic ;
     C        : in Std_Ulogic ;
     D        : in Std_Ulogic 
     ) ;
end component;

for all : ANDGATE use entity SN54xx21.SN54xx21(BEHAVIORAL);

----------------------------------------

begin

  PART1: ANDGATE 
  generic map(
    TWD_A => TWD_A1,
    TWD_B => TWD_B1,
    TWD_C => TWD_C1,
    TWD_D => TWD_D1,
    CL_Y  => CL_Y1
  )
  port map (
    Y    => Y1,
    A    => A1,
    B    => B1,
    C    => C1,
    D    => D1
  ) ;

----------------------------------------

  PART2: ANDGATE
  generic map(
    TWD_A => TWD_A2,
    TWD_B => TWD_B2,
    TWD_C => TWD_C2,
    TWD_D => TWD_D2,
    CL_Y  => CL_Y2
  )
  port map (
    Y    => Y2,
    A    => A2,
    B    => B2,
    C    => C2,
    D    => D2
  ) ;

----------------------------------------

end STRUCTURAL;
