-- Filename : waves_device_SN54xx20.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is ( TP_Y1, TP_Y2, TP_A1, TP_B1, TP_C1, TP_D1, 
                      TP_A2, TP_B2, TP_C2, TP_D2);

  constant DEVICE_ID : string := "SN54xx20";

  -- The following declaration is just for documentation purposes.

  constant PIN_DIRECTION : Direction_List := (Response,   -- TP_Y1
                                              Response,   -- TP_Y2
                                              Stimulus,   -- TP_A1
                                              Stimulus,   -- TP_B1
                                              Stimulus,   -- TP_C1
                                              Stimulus,   -- TP_D1
                                              Stimulus,   -- TP_A2
                                              Stimulus,   -- TP_B2
                                              Stimulus,   -- TP_C2
                                              Stimulus);  -- TP_D2)
        
  function PIN_NAME (PIN : Test_Pins) return String;
    
end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_Y1    => return "Y1";
      when TP_Y2    => return "Y2";
      when TP_A1    => return "A1";
      when TP_B1    => return "B1";
      when TP_C1    => return "C1";
      when TP_D1    => return "D1";
      when TP_A2    => return "A2";
      when TP_B2    => return "B2";
      when TP_C2    => return "C2";
      when TP_D2    => return "D2";
    end case;
  end;
end WAVES_DEVICE;

