-- Filename : SN54xx20_TB_CON.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library STD_PACK;
  use STD_PACK.SIMFLAG.all;    -- Global simulation options
  use STD_PACK.TTL_TIMING.all; -- TTL derating coefficients

library SN54xx20;
  use SN54xx20.SN54xx20_TIMING.all;  -- timing module

configuration SN54xx20_TB_CON of SN54xx20_TB is

for TEST_BENCH
  for UNDER_TEST : DUT use entity SN54xx20.SN54xx20_DIP14(STRUCTURAL)
    generic map (
      DIP_TIME_MODE => TYPICAL,      -- MIN, TYP, or MAX
      DIP_FAMILY    => STD_FAMILY,   -- STD, S, or LS
      DIP_VCC       => 5.0,          -- Volts
      DIP_TA        => 25.0,         -- degrees Celsius
      DIP_DFACTOR   => 100.0,        -- percent
      DIP_REF       => "SN54xx20",   -- component reference designator

      TWD_A1 => 0 ns,  -- back-annotated input wire delays
      TWD_B1 => 0 ns,
      TWD_C1 => 0 ns,
      TWD_D1 => 0 ns,
      TWD_A2 => 0 ns,
      TWD_B2 => 0 ns,
      TWD_C2 => 0 ns,
      TWD_D2 => 0 ns,

      CL_Y1 => 15.0,   -- back-annotated output loading (picofarads)
      CL_Y2 => 15.0   -- (timing module will adjust time accordingly)
    );

  end for;
end for;        

end SN54xx20_TB_CON;
