-- Filename : SN54xx20_TB.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_INTERFACE.all;
  
library SN54xx20;
  use SN54xx20.WAVES_DEVICE.all;
  use SN54xx20.WAVES_OBJECTS.all;
  use SN54xx20.WAVES_UTILITIES.all;
  use SN54xx20.WGENERATOR_SN54xx20.all;

entity SN54xx20_TB is
  begin
end SN54xx20_TB;


-- ======================================================================

architecture TEST_BENCH of SN54xx20_TB is

  component DUT 
    port (Y1, Y2                         : out Std_Ulogic;
          A1, B1, C1, D1, A2, B2, C2, D2 : in  Std_Ulogic );
  end component;

  subtype Test_Pin_Range is integer range
    Test_Pins'pos(TP_Y1) + 1 to Test_Pins'pos(TP_D2) + 1;

  -- Input and Output traffic of DUT
  signal TRAFFIC : Std_Ulogic_Vector(Test_Pin_Range);

  -- Test program options
  constant IN_FILE_NAME    : String := "SN54xx20_WAVES.DAT";
  constant START_TOLERANCE : Time   := 2 ns;
  constant END_TOLERANCE   :Time    := 2 ns;
  
  -- Comparator options
  signal COMPARE           : Boolean           := TRUE;
  constant HOW_TO_REPORT   : Comparison_Format := DO_ASSERTION;
  constant ASSERTION_LEVEL : Severity_Level    := WARNING;

  -- Signal monitor options
  constant HOW_TO_PRINT  : Output_Format := STANDARD;
  constant OUT_FILE_NAME : String        := "SN54xx20_out.dat";

  --    signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) := (others.M_VALUE => TRUE);
  signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range);

  -- Connection to WAVES dataset
  signal CONNECT : Waves_Port_List (Test_Pin_Range);

  subtype Compare_Pin_Range is Integer range
    Test_Pins'pos(TP_Y1) + 1 to Test_Pins'pos(TP_Y2) + 1;

------------------------------------------------------------------------------

begin

  -- Call the waveform generator (i.e., the WAVES dataset)
    process begin
      -- SN54xx20_TEST(CONNECT, IN_FILE_NAME, START_TOLERANCE, END_TOLERANCE);
      SN54xx20_TEST(CONNECT);
      wait;
    end process;

----------------------------------------------------------------------------
  -- Instantiate the Device under test

  UNDER_TEST : DUT
    port map 
    (
      TRAFFIC(Test_Pins'pos(TP_Y1) + 1),
      TRAFFIC(Test_Pins'pos(TP_Y2) + 1),
      TRAFFIC(Test_Pins'pos(TP_A1) + 1),
      TRAFFIC(Test_Pins'pos(TP_B1) + 1),
      TRAFFIC(Test_Pins'pos(TP_C1) + 1),
      TRAFFIC(Test_Pins'pos(TP_D1) + 1),
      TRAFFIC(Test_Pins'pos(TP_A2) + 1),
      TRAFFIC(Test_Pins'pos(TP_B2) + 1),
      TRAFFIC(Test_Pins'pos(TP_C2) + 1),
      TRAFFIC(Test_Pins'pos(TP_D2) + 1)
    );

----------------------------------------------------------------------------
  -- Collect all signals (inputs and output of DUT) into signal TRAFFIC

  COLLECT_INPUTS:
    for I in Test_Pins'pos(TP_A1) + 1 to Test_Pins'pos(TP_D2) + 1 generate
      TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
        (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I)));
  end generate COLLECT_INPUTS;

----------------------------------------------------------------------------

  SIGNAL_TRAFFIC : SIGNAL_MONITOR(OUT_FILE_NAME, TRAFFIC, HOW_TO_PRINT);

----------------------------------------------------------------------------

  GEN_COMPARATOR:
    for I in Compare_Pin_Range generate
      COMPARATOR : CHECK_RESPONSE
      (
        WHICH_ONE => I,
        RESPONSE => TRAFFIC(I),
        PREDICTION => CONNECT(I),
        COMPARE => COMPARE,
        HOW_TO_REPORT => HOW_TO_REPORT,
        ASSERTION_LEVEL => ASSERTION_LEVEL,
        MATCH => SMATCH(I).M_VALUE 
      );
  end generate GEN_COMPARATOR;

end TEST_BENCH;

