-- Filename : waves_device_SN54xx175.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is ( TP_Q1, TP_QB1, TP_Q2, TP_QB2, TP_Q3, TP_QB3, 
                      TP_Q4, TP_QB4, TP_CLK, TP_D1, TP_D2, TP_D3, 
                      TP_D4, TP_CLR);


  constant DEVICE_ID : String := "SN54xx175";

  -- The following declaration is just for documentation purposes.

  constant PIN_DIRECTION : Direction_List := (Response,   -- TP_Q1
                                              Response,   -- TP_QB1
                                              Response,   -- TP_Q2
                                              Response,   -- TP_QB2
                                              Response,   -- TP_Q3
                                              Response,   -- TP_QB3
                                              Response,   -- TP_Q4
                                              Response,   -- TP_QB4
                                              Stimulus,   -- TP_CLK
                                              Stimulus,   -- TP_D1
                                              Stimulus,   -- TP_D2
                                              Stimulus,   -- TP_D3
                                              Stimulus,   -- TP_D4
                                              Stimulus);   -- TP_CLR)
        
  function PIN_NAME (PIN : Test_Pins) return String;

end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_Q1    => return "Q1";
      when TP_QB1   => return "QB1";
      when TP_Q2    => return "Q2";
      when TP_QB2   => return "QB2";
      when TP_Q3    => return "Q3";
      when TP_QB3   => return "QB3";
      when TP_Q4    => return "Q4";
      when TP_QB4   => return "QB4";
      when TP_CLK   => return "CLK";
      when TP_D1    => return "D1";
      when TP_D2    => return "D2";
      when TP_D3    => return "D3";
      when TP_D4    => return "D4";
      when TP_CLR   => return "CLR";
    end case;
  end;
end WAVES_DEVICE;

