-- Filename : SN54xx175_TB_CON.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library STD_PACK;
  use STD_PACK.SIMFLAG.all;    -- Global simulation options
  use STD_PACK.TTL_TIMING.all; -- TTL derating coefficients

library SN54xx175;
  use SN54xx175.SN54xx175_TIMING.all;  -- timing module

configuration SN54xx175_TB_CON of SN54xx175_TB is

for TEST_BENCH
  for UNDER_TEST : DUT use entity SN54xx175.SN54xx175_DIP16(STRUCTURAL)
      generic map (
        DIP_TIME_MODE   => TYPICAL,
        DIP_XGEN        => TRUE,
        DIP_TIMING_MESG => TRUE,
        DIP_FAMILY      => STD_FAMILY,
        DIP_VCC         => 5.0,   -- Volts
        DIP_TA          => 25.0,  -- degrees Celsius
        DIP_DFACTOR     => 100.0, -- percent
        DIP_REF         => "SN54xx175",
    
        TWD_CLK => 0.0 ns,    -- wire delays for each input pin
        TWD_D1  => 0.0 ns,
        TWD_D2  => 0.0 ns,
        TWD_D3  => 0.0 ns,
        TWD_D4  => 0.0 ns,
        TWD_CLR => 0.0 ns,

        CL_Q1   => 15.0, -- pf
        CL_QB1  => 15.0,
        CL_Q2   => 15.0,
        CL_QB2  => 15.0,
        CL_Q3   => 15.0,
        CL_QB3  => 15.0,
        CL_Q4   => 15.0,
        CL_QB4  => 15.0 
      );

  end for;
end for;        

end SN54xx175_TB_CON;
