-- Filename : SN54xx175_TB.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library SN54xx175;
  use SN54xx175.WAVES_DEVICE.all;
  use SN54xx175.WAVES_OBJECTS.all;
  use SN54xx175.WAVES_UTILITIES.all;
  use SN54xx175.WGENERATOR_SN54xx175.all;

entity SN54xx175_TB is
  begin
end SN54xx175_TB;

-- ======================================================================

architecture TEST_BENCH of SN54xx175_TB is

  component DUT 
  port 
  (
    Q1, QB1, Q2, QB2, Q3, QB3, Q4, QB4 : out Std_Ulogic;
    CLK, D1, D2, D3, D4, CLR           : in  Std_Ulogic );
  end component;

  subtype Test_Pin_Range is Integer range
    Test_Pins'pos(TP_Q1) + 1 to Test_Pins'pos(TP_CLR) + 1;

  -- Input and Output traffic of DUT
  signal TRAFFIC : Std_Ulogic_Vector(Test_Pin_Range);

  -- Test program options
  constant IN_FILE_NAME    : String := "SN54xx175_WAVES.DAT";
  constant START_TOLERANCE : Time   := 2 ns;
  constant END_TOLERANCE    : Time  := 2 ns;

  -- Comparator options
  signal COMPARE          : Boolean           := TRUE;
  constant HOW_TO_REPORT  : Comparison_Format := DO_ASSERTION;
  constant ASSERTION_LEVEL : Severity_Level   := WARNING;

  -- Signal monitor options
  constant HOW_TO_PRINT  : Output_Format := STANDARD; --WAVES;
  constant OUT_FILE_NAME : String        := "SN54xx175_out.dat";

  --signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) := (others.M_VALUE => TRUE);
  signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range);

  -- Connection to WAVES dataset
  signal CONNECT : Waves_Port_List (Test_Pin_Range);

  subtype Compare_Pin_Range is Integer range
    Test_Pins'pos(TP_Q1) + 1 to Test_Pins'pos(TP_QB4) + 1;

------------------------------------------------------------------------------

begin

  -- Call the waveform generator (i.e., the WAVES dataset)
  process begin
    -- SN54xx175_TEST(CONNECT, IN_FILE_NAME, START_TOLERANCE, END_TOLERANCE);
    SN54xx175_TEST(CONNECT);
    wait;
  end process;

----------------------------------------------------------------------------

  -- Instantiate the Device under test

  UNDER_TEST : DUT
  port map 
  (
    TRAFFIC(Test_Pins'pos(TP_Q1) + 1),
    TRAFFIC(Test_Pins'pos(TP_QB1) + 1),
    TRAFFIC(Test_Pins'pos(TP_Q2) + 1),
    TRAFFIC(Test_Pins'pos(TP_QB2) + 1),
    TRAFFIC(Test_Pins'pos(TP_Q3) + 1),
    TRAFFIC(Test_Pins'pos(TP_QB3) + 1),
    TRAFFIC(Test_Pins'pos(TP_Q4) + 1),
    TRAFFIC(Test_Pins'pos(TP_QB4) + 1),
    TRAFFIC(Test_Pins'pos(TP_CLK) + 1),
    TRAFFIC(Test_Pins'pos(TP_D1) + 1),
    TRAFFIC(Test_Pins'pos(TP_D2) + 1),
    TRAFFIC(Test_Pins'pos(TP_D3) + 1),
    TRAFFIC(Test_Pins'pos(TP_D4) + 1),
    TRAFFIC(Test_Pins'pos(TP_CLR) + 1)
  );

----------------------------------------------------------------------------
  -- Collect all signals (inputs and output of DUT) into signal TRAFFIC

  COLLECT_INPUTS:
    for I in Test_Pins'pos(TP_CLK) + 1 to Test_Pins'pos(TP_CLR) + 1 generate
      TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
        (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I)));
  end generate COLLECT_INPUTS;

----------------------------------------------------------------------------

  SIGNAL_TRAFFIC : SIGNAL_MONITOR(OUT_FILE_NAME, TRAFFIC, HOW_TO_PRINT);

----------------------------------------------------------------------------

  GEN_COMPARATOR:
    for I in Compare_Pin_Range generate
      COMPARATOR : CHECK_RESPONSE
      (
        WHICH_ONE => I,
        RESPONSE => TRAFFIC(I),
        PREDICTION => CONNECT(I),
        COMPARE => COMPARE,
        HOW_TO_REPORT => HOW_TO_REPORT,
        ASSERTION_LEVEL => ASSERTION_LEVEL,
        MATCH => SMATCH(I).M_VALUE 
      );
  end generate GEN_COMPARATOR;
end TEST_BENCH;

