-- Filename : SN54xx175_DIP16.vhd
--
-- Version 2.1
--
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--      
-- Part Name:          SN54xx175
-- Manufacturer:       Texas Instruments
-- Other Sources:      Advanced Micro Devices
-- Reference:          Data Sheet - The 1988 TTL Data Book (p. 2-586)
-- Packaging:          J Suffix (ceramic 16 pin DIP), or
--                     W Suffix (ceramic flat package)
--
-- Description:       The bipolar SSI SN54xx175 is a quad D flip-flop with common clock
--                    and master clear.  Signals at the D inputs meeting the setup
--                    time are transferred to the Q outputs on the positive-going
--                    edge of the clock pulse.  Clock triggering occurs at a particular
--                    voltage level and is not directly related to the transistion time
--                    of the positive-going pulse. When the clock input is at
--                    either the high or low level, the D input signal has no
--                    effect at the output.
--                    The '54 series meets military specifications.
--
--
-- Developer:         Institute for Technology Development
--                    VHDL Modeling Group
--                    1 Research Boulevard, Suite 205
--                    Starkville, MS 39759
--
-- Contact:           Dan Johnson
--                    CAD Section Manager
--                    (601) 325-2240
--                    danj@itd.msstate.edu
--
-- Version            2.1
-- Date:              07-12-91
--
-- Date of Formal
-- Verification:      TBD
--
--
--        ------------------------------------------------------------------
--
--
-- Recommended operating conditions:
--
--   STD_FAMILY
--    ___________________________________________________
--   |            |  minimum  nominal  maximum  |  unit  |
--   |____________|_____________________________|________|
--   | VCC        |  4.5      5.0      5.5      | V      |
--   | IOH        |                   -800      | uA     |
--   | IOL        |                     16      | mA     |
--   | fclock     |   0                 25      | MHz    | 
--   | tw         |  20                         | ns     |
--   | tsu(data)  |  20                         | ns     |
--   | tsu(clear) |  25                         | ns     |
--   | th         |   5                         | ns     |
--   | TA         | -55       25       125      | deg. C |
--   |____________|_____________________________|________|
--
--
--   S_FAMILY
--    ___________________________________________________
--   |            |  minimum  nominal  maximum  |  unit  |
--   |____________|_____________________________|________|
--   | VCC        |  4.5      5.0      5.5      | V      |
--   | IOH        |                   -1.0      | uA     |
--   | IOL        |                     20      | mA     |
--   | fclock     |   0                 75      | MHz    | 
--   | tw(clock)  |   7                         | ns     |
--   | tw(clear)  |  10                         | ns     |
--   | tsu(data)  |   5                         | ns     |
--   | tsu(clear) |   5                         | ns     |
--   | th         |   3                         | ns     |
--   | TA         | -55        25      125      | deg. C |
--   |____________|_____________________________|________|

--
--
--   LS_FAMILY
--    ___________________________________________________
--   |            |  minimum  nominal  maximum  |  unit  |
--   |____________|_____________________________|________|
--   | VCC        |  4.5      5.0      5.5      | V      |
--   | IOH        |                   -400      | uA     |
--   | IOL        |                      4      | mA     |
--   | fclock     |   0                 30      | MHz    | 
--   | tw         |  20                         | ns     |
--   | tsu(data)  |  20                         | ns     |
--   | tsu(clear) |  25                         | ns     |
--   | th         |   5                         | ns     |
--   | TA         | -55        25      125      | deg. C |
--   |____________|_____________________________|________|
--
--
--
-- Worst case operating conditions:
--    _________________________________
--   |        | voltage   temperature  |
--   | _______|________________________|
--   | tphl   | 5.5 V     -55 deg. C   |
--   | tplh   | 4.5 V     125 deg. C   |
--   |________|________________________|
--
-- Note: High capacitive loading also degrades propagation delays of the part.


library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all ;   -- Defines logic types, operators, functions

library STD_PACK ;                  -- Standard library for all models
  use STD_PACK.SIMFLAG.all;         -- Global simulation parameters
  use STD_PACK.TTL_TIMING.all;      -- Environmental derating coefficients

library SN54xx175;
  use SN54xx175.SN54xx175_TIMING.all;  -- Timing module

------------------------------------------------------------
entity SN54xx175_DIP16 is 

  generic
    -- simulation defaults are from SIMFLAG package
  (
    DIP_TIME_MODE   : Time_Modes := TYPICAL;
    DIP_XGEN        : Boolean    := X_GEN;
    DIP_TIMING_MESG : Boolean    := TIMING_MESG;
    DIP_FAMILY      : Tech_Type  := STD_FAMILY;
    DIP_VCC         : Real       := VCC;
    DIP_TA          : Real       := TA;
    DIP_DFACTOR     : Real       := DERATE_FACTOR;
    DIP_REF         : String     := "SN54xx109";

    TWD_CLK  : Time := 0.0 ns;    -- wire delays for each input pin
    TWD_D1   : Time := 0.0 ns;
    TWD_D2   : Time := 0.0 ns;
    TWD_D3   : Time := 0.0 ns;
    TWD_D4   : Time := 0.0 ns;
    TWD_CLR  : Time := 0.0 ns;

    CL_Q1   : Real := 15.0; -- pf
    CL_QB1  : Real := 15.0;
    CL_Q2   : Real := 15.0;
    CL_QB2  : Real := 15.0;
    CL_Q3   : Real := 15.0;
    CL_QB3  : Real := 15.0;
    CL_Q4   : Real := 15.0;
    CL_QB4  : Real := 15.0 
  );

  port(
     Q1        : out Std_Ulogic ;
     QB1       : out Std_Ulogic ;
     Q2        : out Std_Ulogic ;
     QB2       : out Std_Ulogic ;
     Q3        : out Std_Ulogic ;
     QB3       : out Std_Ulogic ;
     Q4        : out Std_Ulogic ;
     QB4       : out Std_Ulogic ;
  
     CLK       : in Std_Ulogic ;
     D1        : in Std_Ulogic ;
     D2        : in Std_Ulogic ;
     D3        : in Std_Ulogic ;
     D4        : in Std_Ulogic ;
     CLR       : in Std_Ulogic ;

     VCC       : in Real := 5.0;  -- volts
     GND       : in Real := 0.0   -- volts

   ) ;

   -- pin mapping for J or W package

   attribute PIN_NO         : positive ;
   attribute PIN_NO of CLR  : signal is 1 ;
   attribute PIN_NO of Q1   : signal is 2 ;
   attribute PIN_NO of QB1  : signal is 3 ;
   attribute PIN_NO of D1   : signal is 4 ;
   attribute PIN_NO of D2   : signal is 5 ;
   attribute PIN_NO of QB2  : signal is 6 ;
   attribute PIN_NO of Q2   : signal is 7 ;
   attribute PIN_NO of GND  : signal is 8 ;
   attribute PIN_NO of CLK  : signal is 9 ;
   attribute PIN_NO of Q3   : signal is 10 ;
   attribute PIN_NO of QB3  : signal is 11 ;
   attribute PIN_NO of D3   : signal is 12 ;
   attribute PIN_NO of D4   : signal is 13 ;
   attribute PIN_NO of QB4  : signal is 14 ;
   attribute PIN_NO of Q4   : signal is 15 ;
   attribute PIN_NO of VCC  : signal is 16 ;

end SN54xx175_DIP16;

------------------------------------------------------------
architecture STRUCTURAL of SN54xx175_DIP16 is

  component DFF
  generic
  (
     GEN_PROP_TIMES  : Prop_Times := GET_TIMING(DIP_FAMILY,
                                                DIP_TIME_MODE,
                                                DIP_VCC,
                                                DIP_TA,
                                                DIP_DFACTOR);
       GEN_XGEN        : Boolean    := DIP_XGEN;
       GEN_TIMING_MESG : Boolean    := DIP_TIMING_MESG;
       GEN_FAMILY      : Tech_Type  := DIP_FAMILY;  
       GEN_TW_CLK      : Time       := TW_CLK (DIP_FAMILY);
       GEN_TW_CLR      : Time       := TW_CLR (DIP_FAMILY);
       GEN_TSU_DATA    : Time       := TSU_DATA (DIP_FAMILY);
       GEN_TSU_CLR     : Time       := TSU_CLR (DIP_FAMILY);
       GEN_TH          : Time       := TH (DIP_FAMILY);
  
       TWD_CLK  : Time;
       TWD_D    : Time;
       TWD_CLR  : Time;
  
       CL_Q     : Real;
       CL_QB    : Real;
  
       REF  : String := DIP_REF
  );

  port (
     Q     : out Std_Ulogic ;
     QB    : out Std_Ulogic ;
  
     CLK   : in Std_Ulogic ;
     D     : in Std_Ulogic ;
     CLR   : in Std_Ulogic 
   ) ;

  end component;

  for all : DFF use entity SN54xx175.SN54xx175(BEHAVIORAL);


----------------------------------------------------------------------

begin

  PART1: DFF 
  generic map (
     TWD_CLK    => TWD_CLK,
     TWD_D      => TWD_D1,
     TWD_CLR    => TWD_CLR,

     CL_Q       => CL_Q1,
     CL_QB      => CL_QB1
  )

  port map (
     Q     => Q1,
     QB    => QB1,

     CLK   => CLK,
     D     => D1,
     CLR   => CLR
     ) ;

----------------------------------------------------------------------

  PART2: DFF 

  generic map (
     TWD_CLK    => TWD_CLK,
     TWD_D      => TWD_D2,
     TWD_CLR    => TWD_CLR,

     CL_Q       => CL_Q2,
     CL_QB      => CL_QB2
  )

  port map (
     Q     => Q2,
     QB    => QB2,

     CLK   => CLK,
     D     => D2,
     CLR   => CLR
     ) ;

----------------------------------------------------------------------

  PART3: DFF 

  generic map (
     TWD_CLK    => TWD_CLK,
     TWD_D      => TWD_D3,
     TWD_CLR    => TWD_CLR,

     CL_Q       => CL_Q3,
     CL_QB      => CL_QB3
  )

  port map (
     Q     => Q3,
     QB    => QB3,

     CLK   => CLK,
     D     => D3,
     CLR   => CLR
     ) ;

----------------------------------------------------------------------

  PART4: DFF 
  generic map (
     TWD_CLK    => TWD_CLK,
     TWD_D      => TWD_D4,
     TWD_CLR    => TWD_CLR,

     CL_Q       => CL_Q4,
     CL_QB      => CL_QB4
  )

  port map (
     Q     => Q4,
     QB    => QB4,

     CLK   => CLK,
     D     => D4,
     CLR   => CLR
     ) ;

----------------------------------------------------------------------

end STRUCTURAL;


