-- Filename : waves_device_SN54xx161A.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is
  (
    TP_QA, TP_QB, TP_QC, TP_QD, TP_RC,
    TP_CLK, TP_A, TP_B, TP_C, TP_D, 
    TP_ENP, TP_ENT, TP_LOAD, TP_CLR
  );

  constant DEVICE_ID : String := "SN54xx161A";

  -- The following declaration is just for documentation purposes.

  constant PIN_DIRECTION : Direction_List :=
  (
    Response,   -- TP_QA
    Response,   -- TP_QB
    Response,   -- TP_QC
    Response,   -- TP_QD
    Response,   -- TP_RC
    Stimulus,   -- TP_CLR
    Stimulus,   -- TP_CLK
    Stimulus,   -- TP_A
    Stimulus,   -- TP_B
    Stimulus,   -- TP_C
    Stimulus,   -- TP_D
    Stimulus,   -- TP_ENP
    Stimulus,   -- TP_LOAD
    Stimulus);    -- TP_ENT)
        
  function PIN_NAME (PIN : Test_Pins) return String;
    
end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_QA    => return "QA";
      when TP_QB    => return "QB";
      when TP_QC    => return "QC";
      when TP_QD    => return "QD";
      when TP_RC    => return "RC";
      when TP_CLR   => return "CLR";
      when TP_CLK   => return "CLK";
      when TP_A     => return "A";
      when TP_B     => return "B";
      when TP_C     => return "C";
      when TP_D     => return "D";
      when TP_ENP   => return "ENP";
      when TP_LOAD  => return "LOAD";
      when TP_ENT   => return "ENT";
    end case;
  end;

end WAVES_DEVICE;    

