-- Filename : SN54xx161A_TB_CON.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library STD_PACK;
use STD_PACK.SIMFLAG.all;
use STD_PACK.TTL_TIMING.all;

library SN54XX161A;
use SN54XX161A.SN54XX161A_TIMING.all;

configuration SN54xx161A_TB_CON of SN54xx161A_TB is

  for TEST_BENCH
    for UNDER_TEST : DUT use entity SN54xx161A.SN54xx161A_DIP16(STRUCTURAL)
      generic map (
        DIP_TIME_MODE   => MINIMUM,
        DIP_XGEN        => TRUE,
        DIP_TIMING_MESG => TRUE,
        DIP_FAMILY      => LS_FAMILY,
        DIP_VCC         => 5.0,   -- Volts
        DIP_TA          => 25.0,  -- degrees Celsius
        DIP_DFACTOR     => 100.0, -- percent

        DIP_REF  => "SN54xx161A",

        TWD_CLR  => 0.0 ns,
        TWD_CLK  => 0.0 ns,
        TWD_A    => 0.0 ns,
        TWD_B    => 0.0 ns,
        TWD_C    => 0.0 ns,
        TWD_D    => 0.0 ns,
        TWD_ENP  => 0.0 ns,
        TWD_LOAD => 0.0 ns,
        TWD_ENT  => 0.0 ns,

        CL_QA    => 15.0, -- pf,
        CL_QB    => 15.0, -- pf,
        CL_QC    => 15.0, -- pf,
        CL_QD    => 15.0, -- pf,
        CL_RCO   => 15.0  -- pf,
      );

    end for;
  end for;        

end SN54xx161A_TB_CON;
