-- Filename : SN54xx161A_TB.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library SN54xx161A;
  use SN54xx161A.WAVES_DEVICE.all;
  use SN54xx161A.WAVES_OBJECTS.all;
  use SN54xx161A.WAVES_UTILITIES.all;
  use SN54xx161A.WGENERATOR_SN54xx161A.all;

entity SN54xx161A_TB is
  begin
end SN54xx161A_TB;

-- ======================================================================

architecture TEST_BENCH of SN54xx161A_TB is

  component DUT port
  (
    QA, QB, QC, QD, RC : out Std_Ulogic;
    CLR, CLK, A, B, C, D, ENP, LOAD, ENT : in  Std_Ulogic
  );
  end component;

  subtype Test_Pin_Range is Integer range
    Test_Pins'pos(TP_QA) + 1 to Test_Pins'pos(TP_CLR) + 1;

  -- Input and Output traffic of DUT
  signal TRAFFIC : Std_Ulogic_Vector(Test_Pin_Range);

  -- Test program options
  constant IN_FILE_NAME    : String := "SN54xx161A_waves.dat";
  constant START_TOLERANCE : Time   := 2 ns;
  constant END_TOLERANCE   : Time   := 2 ns;

  -- Comparator options
  signal COMPARE          : Boolean           := TRUE;
  constant HOW_TO_REPORT  : Comparison_Format := DO_ASSERTION;
  constant ASSERTION_LEVEL : Severity_Level   := WARNING;

  -- Signal monitor options
  constant HOW_TO_PRINT  : Output_Format := STANDARD;
  constant OUT_FILE_NAME : String        := "SN54xx161A_out.dat";

  -- signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) :=
  -- (others.M_VALUE => TRUE);
  signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range);

  -- Connection to WAVES dataset
  signal CONNECT : Waves_Port_List (Test_Pin_Range);

  subtype Compare_Pin_Range is Integer range
    Test_Pins'pos(TP_QA) + 1 to Test_Pins'pos(TP_RC) + 1;

------------------------------------------------------------------------------
begin

  -- Call the waveform generator (i.e., the WAVES dataset)
    process begin
    -- SN54xx161A_TEST(CONNECT, IN_FILE_NAME, START_TOLERANCE, END_TOLERANCE);
    SN54xx161A_TEST(CONNECT);
    wait;
  end process;

----------------------------------------------------------------------------

  -- Instantiate the Device under test
  UNDER_TEST : DUT
  port map
  (
    TRAFFIC(Test_Pins'pos(TP_QA) + 1),
    TRAFFIC(Test_Pins'pos(TP_QB) + 1),
    TRAFFIC(Test_Pins'pos(TP_QC) + 1),
    TRAFFIC(Test_Pins'pos(TP_QD) + 1),
    TRAFFIC(Test_Pins'pos(TP_RC) + 1),
    TRAFFIC(Test_Pins'pos(TP_CLR) + 1),
    TRAFFIC(Test_Pins'pos(TP_CLK) + 1),
    TRAFFIC(Test_Pins'pos(TP_A) + 1),
    TRAFFIC(Test_Pins'pos(TP_B) + 1),
    TRAFFIC(Test_Pins'pos(TP_C) + 1),
    TRAFFIC(Test_Pins'pos(TP_D) + 1),
    TRAFFIC(Test_Pins'pos(TP_ENP) + 1),
    TRAFFIC(Test_Pins'pos(TP_LOAD) + 1),
    TRAFFIC(Test_Pins'pos(TP_ENT) + 1)
  );

----------------------------------------------------------------------------
  -- Collect all signals (inputs and output of DUT) into signal TRAFFIC

  COLLECT_INPUTS:
  for I in Test_Pins'pos(TP_CLK) + 1 to Test_Pins'pos(TP_CLR) + 1 generate
    TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
                  (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I)));
  end generate COLLECT_INPUTS;

----------------------------------------------------------------------------

  SIGNAL_TRAFFIC : SIGNAL_MONITOR(OUT_FILE_NAME, TRAFFIC, HOW_TO_PRINT);

----------------------------------------------------------------------------

  GEN_COMPARATOR:
    for I in Compare_Pin_Range generate
      COMPARATOR : CHECK_RESPONSE
      (
        WHICH_ONE         => I,
        RESPONSE          => TRAFFIC(I),
        PREDICTION        => CONNECT(I),
        COMPARE           => COMPARE,
        HOW_TO_REPORT     => HOW_TO_REPORT,
        ASSERTION_LEVEL   => ASSERTION_LEVEL,
        MATCH             => SMATCH(I).M_VALUE
      );

  end generate GEN_COMPARATOR;

end TEST_BENCH;

