-- Filename : SN54xx161A_DIP16.vhd
--
-- Version 2.1
--
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--      
-- Part Name:          SN54xx161A
-- Manufacturer:       Texas Instruments
-- Other Sources:      Motorola, Advanced Micro Devices
-- Reference:          Data Sheet - The 1974 TTL Data Book (p. S178-S179)
-- Packaging:          J Suffix (ceramic 16 pin DIP), or
--                     W Suffix (ceramic flat package)
-- 
-- Description:       The bipolar SSI SN54xx161A is a 4-bit synchronous
--                    counter with synchronous load and master clear.
--                    The SN54xx161A features carry look-ahead
--                    and two seperate enable pins.  Synchronous
--                    operation is provided by having all flip-flops
--                    clocked simultaneously so that the outputs
--                    change coincident with each other when
--                    so instructed by the count-enable inputs and
--                    internal gating. The counter is fully
--                    programmable; that is, the outputs may be
--                    preset to either level. The carry look-ahead
--                    circuitry provides for cascading counters for
--                    n-bit synchronous applications without additional
--                    gating. The '54 series meets military specifications. 
--                    
-- 
-- Developer:         Institute for Technology Development
--                    VHDL Modeling Group
--                    1 Research Boulevard, Suite 205
--                    Starkville, MS 39759
-- 
-- Contact:           Dan Johnson
--                    CAD Section Manager
--                    (601) 325-2240
--                    danj@itd.msstate.edu
-- 
-- Version            2.1
-- Date:              07-12-91
-- 
-- Date of Formal
-- Verification:      TBD
--
--
--        ------------------------------------------------------------------
--
--
-- Recommended operating conditions:
--
--   LS_FAMILY
--    __________________________________________________
--   |           |  minimum  nominal  maximum  |  unit  |
--   |___________|_____________________________|________|
--   | VCC       | 4.5         5.0    5.5      | V      |
--   | IOH       |                   -800      | uA     |
--   | IOL       |                     16      | mA     |
--   | fclock    |   0                 25      | MHz    |
--   | tw(CLOCK) |  25                         | ns     |
--   | tw(CLEAR) |  20                         | ns     |
--   | tsu(DATA) |  20                         | ns     |
--   | tsu(ENP)  |  20                         | ns     |
--   | tsu(LOAD) |  25                         | ns     |
--   | tsu(CLR)  |  20                         | ns     |
--   | th        |   0                         | ns     |
--   | TA        | -55          25    125      | deg. C |
--   |___________|_____________________________|________|
--
--
-- Worst case operating conditions:
--    _________________________________
--   |        | voltage   temperature  |
--   | _______|________________________|
--   | tphl   | 5.5 V     -55 deg. C   |
--   | tplh   | 4.5 V     125 deg. C   |
--   |________|________________________|
--
-- Note: High capacitive loading also degrades propagation delays of the part.


library IEEE;                     -- Logic system
  use IEEE.STD_LOGIC_1164.all ;   -- Defines logic types, operators, functions

library STD_PACK ;                -- Standard library for all models
  use STD_PACK.SIMFLAG.all;       -- Global simulation parameters
  use STD_PACK.TTL_TIMING.all;    -- Environmental derating coefficients

library SN54xx161A;
  use SN54xx161A.SN54xx161A_TIMING.all;  -- Timing module

------------------------------------------------------------
entity SN54xx161A_DIP16 is 

  generic
  (
    -- simulation defaults are from SIMFLAG package

    DIP_TIME_MODE   : Time_Modes := TYPICAL;
    DIP_XGEN        : Boolean    := X_GEN;
    DIP_TIMING_MESG : Boolean    := TIMING_MESG;
    DIP_FAMILY      : Tech_Type  := S_FAMILY;
    DIP_VCC         : Real       := VCC;
    DIP_TA          : Real       := TA;
    DIP_DFACTOR     : Real       := DERATE_FACTOR;
    DIP_REF         : String     := "SN54xx161A";

    TWD_CLR  : Time := 0.0 ns;
    TWD_CLK  : Time := 0.0 ns;
    TWD_A    : Time := 0.0 ns;
    TWD_B    : Time := 0.0 ns;
    TWD_C    : Time := 0.0 ns;
    TWD_D    : Time := 0.0 ns;
    TWD_ENP  : Time := 0.0 ns;
    TWD_LOAD : Time := 0.0 ns;
    TWD_ENT  : Time := 0.0 ns;

    CL_QA    : Real := 15.0; -- pf
    CL_QB    : Real := 15.0; -- pf
    CL_QC    : Real := 15.0; -- pf
    CL_QD    : Real := 15.0; -- pf
    CL_RCO   : Real := 15.0  -- pf
  );

  port(
     QA        : out Std_Ulogic ;
     QB        : out Std_Ulogic ;
     QC        : out Std_Ulogic ;
     QD        : out Std_Ulogic ;
     RC        : out Std_Ulogic ;

     CLR       : in Std_Ulogic ;
     CLK       : in Std_Ulogic ;
     A         : in Std_Ulogic ;
     B         : in Std_Ulogic ;
     C         : in Std_Ulogic ;
     D         : in Std_Ulogic ;
     ENP       : in Std_Ulogic ;
     LOAD      : in Std_Ulogic ;
     ENT       : in Std_Ulogic ;

     VCC       : in Real := 5.0;  -- volts
     GND       : in Real := 0.0   -- volts

   ) ;

   -- PIN MAPPING

   attribute PIN_NO : positive ;
   attribute PIN_NO of CLR   : signal is 1 ;
   attribute PIN_NO of CLK   : signal is 2 ;
   attribute PIN_NO of A     : signal is 3 ;
   attribute PIN_NO of B     : signal is 4 ;
   attribute PIN_NO of C     : signal is 5 ;
   attribute PIN_NO of D     : signal is 6 ;
   attribute PIN_NO of ENP   : signal is 7 ;
   attribute PIN_NO of GND   : signal is 8 ;
   attribute PIN_NO of LOAD  : signal is 9 ;
   attribute PIN_NO of ENT   : signal is 10 ;
   attribute PIN_NO of QA    : signal is 11 ;
   attribute PIN_NO of QB    : signal is 12 ;
   attribute PIN_NO of QC    : signal is 13 ;
   attribute PIN_NO of QD    : signal is 14 ;
   attribute PIN_NO of RC    : signal is 15 ;
   attribute PIN_NO of VCC   : signal is 16 ;

end SN54xx161A_DIP16;

------------------------------------------------------------

architecture STRUCTURAL of SN54xx161A_DIP16 is

  component COUNTER

    generic 
    (
      GEN_PROP_TIMES  : Prop_Times := GET_TIMING(DIP_FAMILY,
                                                 DIP_TIME_MODE,
                                                 DIP_VCC,
                                                 DIP_TA,
                                                 DIP_DFACTOR);
 
      GEN_XGEN        : Boolean    := DIP_XGEN;
      GEN_TIMING_MESG : Boolean    := DIP_TIMING_MESG;
      GEN_FAMILY      : Tech_Type  := DIP_FAMILY;

      GEN_TW_CLK_HI  : Time := TW_CLK_HI (DIP_FAMILY);
      GEN_TW_CLK_LO  : Time := TW_CLK_LO (DIP_FAMILY);
      GEN_TW_CLR     : Time := TW_CLR (DIP_FAMILY);
      GEN_TSU        : Time := TSU (DIP_FAMILY);
      GEN_TH         : Time := TH (DIP_FAMILY);
  
      TWD_CLR  : Time ;
      TWD_CLK  : Time ;
      TWD_A    : Time ;
      TWD_B    : Time ;
      TWD_C    : Time ;
      TWD_D    : Time ;
      TWD_ENP  :Time ;
      TWD_LOAD : Time ;
      TWD_ENT  : Time ;
  
      CL_QA    : Real ;
      CL_QB    : Real ;
      CL_QC    : Real ;
      CL_QD    : Real ;
      CL_RCO   : Real ;
  
      REF  : String := DIP_REF
    );
  
    port (
      QA        : out Std_Ulogic ;
      QB        : out Std_Ulogic ;
      QC        : out Std_Ulogic ;
      QD        : out Std_Ulogic ;
      RC        : out Std_Ulogic ;
  
      CLR       : in Std_Ulogic ;
      CLK       : in Std_Ulogic ;
      A         : in Std_Ulogic ;
      B         : in Std_Ulogic ;
      C         : in Std_Ulogic ;
      D         : in Std_Ulogic ;
      ENP       : in Std_Ulogic ;
      LOAD      : in Std_Ulogic ;
      ENT       : in Std_Ulogic 
    );

  end component;

  for PART1 : COUNTER use entity SN54xx161A.SN54xx161A(BEHAVIORAL);

begin

-- ------------------------------------------------------------

  PART1: COUNTER 
  generic map (
    TWD_CLR  => TWD_CLR,
    TWD_CLK  => TWD_CLK,
    TWD_A    => TWD_A,
    TWD_B    => TWD_B,
    TWD_C    => TWD_C,
    TWD_D    => TWD_D,
    TWD_ENP  => TWD_ENP,
    TWD_LOAD => TWD_LOAD,
    TWD_ENT  => TWD_ENT,

    CL_QA   => CL_QA,
    CL_QB   => CL_QB,
    CL_QC   => CL_QC,
    CL_QD   => CL_QD,
    CL_RCO  => CL_RCO 
  )

  port map (
    QA     => QA,
    QB     => QB,
    QC     => QC,
    QD     => QD,
    RC     => RC,

    CLR   => CLR,
    CLK   => CLK,
    A     => A,
    B     => B,
    C     => C,
    D     => D,
    ENP   => ENP,
    LOAD  => LOAD,
    ENT   => ENT
  );

-- ------------------------------------------------------------

end STRUCTURAL;


