-- Filename : SN54xx140.vhd
--
-- Version 2.1
--
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--      
--        ------------------------------------------------------------------
--
--
-- Recommended operating conditions:
--
--
--   STD_FAMILY is not available for this part.
--
--   S_FAMILY
--    _____________________________________________
--   |      |  minimum  nominal  maximum  |  unit  |
--   |______|_____________________________|________|
--   | VCC  |  4.5      5.0      5.5      | V      |
--   | VIH  |  2.0                        | V      |
--   | VIL  |                    0.8      | V      |
--   | IOH  |                  -40.0      | mA     |
--   | IOL  |                     60      | mA     |
--   | TA   | -55       25       125      | deg. C |
--   |______|_____________________________|________|
--
--
--   LS_FAMILY is not available for this part.
--
-- Worst case operating conditions:
--    _________________________________
--   |        | voltage   temperature  |
--   | _______|________________________|
--   | tphl   | 5.5 V     -50 deg. C   |
--   | tplh   | 4.5 V     125 deg. C   |
--   |________|________________________|
--
-- Note: High capacitive loading also degrades propagation delays of the part.

library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;      -- Defines logic types, operators, functions

library STD_PACK;                     -- Standard library for all models
  use STD_PACK.TIME_FUNC.all;         -- Timing functions
  use STD_PACK.MISC_FUNC.all;         -- Miscellaneous functions
  use STD_PACK.TTL_TIMING.all;       -- TTL derating coefficients
  
library SN54xx140;
  use SN54xx140.SN54xx140_TIMING.all;       -- SN54xx140 timing module

entity SN54xx140 is

  generic
  (
   GEN_PROP_TIMES : Prop_Times;
   GEN_FAMILY : Tech_Type;

   TWD_A : Time;   -- wire delays for each input pin
   TWD_B : Time;
   TWD_C : Time;
   TWD_D : Time;

   CL_Y  : Real;   -- fanout capacitance seen by output (in pf)

   REF : String
  );

  port 
  (
    Y      : out Std_Ulogic;
    A      : in Std_Ulogic;
    B      : in Std_Ulogic;
    C      : in Std_Ulogic;
    D      : in Std_Ulogic
   );
 
end SN54xx140;

-- ======================================================================

architecture behavioral of SN54xx140 is

  constant MODEL_TIMES : Prop_Times := BACK_ANNOTATE(GEN_PROP_TIMES,GEN_FAMILY,CL_Y);

  -- Local signal declarations

  signal AIN,BIN,CIN,DIN : Std_Ulogic := 'U';
  signal YOUT            : UX01Z      := 'U';

begin

  -- assign pin values to local signals after wire delay

  AIN <= transport A after TWD_A;
  BIN <= transport B after TWD_B;
  CIN <= transport C after TWD_C;
  DIN <= transport D after TWD_D;

  -- Assign local values to output pins

  Y <=  YOUT;

-------------------------------------------------------------------------

  NAND4 : process (AIN,BIN,CIN,DIN)

    variable OUTPUT_VALUE : Std_Ulogic;

  begin

    OUTPUT_VALUE := not (AIN and BIN and CIN and DIN);

    YOUT <= transport OUTPUT_VALUE after TP_DELAY(OUTPUT_VALUE,
        MODEL_TIMES.TPLH, MODEL_TIMES.TPHL);
end process NAND4;

-------------------------------------------------------------------------

end BEHAVIORAL;

