-- Filename : wgenerator_SN54xx138.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
  use STD.TEXTIO.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_SYSTEM.all;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library SN54xx138;
  use SN54xx138.WAVES_DEVICE.all;
  use SN54xx138.WAVES_OBJECTS.all;
  use SN54xx138.WAVES_FRAMES.all;
  use SN54xx138.WAVES_UTILITIES.all;

package WGENERATOR_SN54xx138 is
  procedure SN54xx138_TEST
  (
    signal CONNECT   : inout Waves_Port_List
  );

  procedure SN54xx138_TEST
  (
    signal CONNECT   : inout Waves_Port_List;
    constant INPUT_FILE_NAME  : String;
    constant START_TOLERANCE  : Time;
    constant END_TOLERANCE    : Time 
  );

end WGENERATOR_SN54xx138;

-- ======================================================================

package body WGENERATOR_SN54xx138 is

  constant I_PINS : Pinset := NEW_PINSET
  ( 
    (TP_C, TP_B, TP_A, TP_G1, TP_G2A, TP_G2B)
  );

  constant O_PINS : Pinset := ALL_PINS and not I_PINS;
  constant EMPTY_EVENT : Integer := -1;

  ---------------------------------------------------------------------------
  --  The following procedure is used to provide test vectors for the model.
  --  The test vectors (inputs and expected outputs) are contained within
  --  the procedure, and are analyzed with the VHDL code.  The test vectors
  --  are applied as follows:
  --
  --   Beginning of period:  Inputs set to appropriate values
  --                         Expected outputs set to "don't care"
  --
  --   After 95 ns (95% of period):  Expected outputs set to appropriate values
  --
  --   After 100 ns (end of period): Get next set of inputs and outputs
  ---------------------------------------------------------------------------
  procedure SN54xx138_TEST(
    signal CONNECT   : inout Waves_Port_List) is

    constant PERIOD          : Time       := 100 ns;
    constant UNCERTAINTY_PCT : Real       := 0.95;
    constant TDELAY          : Event_Time := ETIME (UNCERTAINTY_PCT * PERIOD);

    constant FSA : Frame_Set_Array := 
      NEW_FRAME_SET_ARRAY ( INPUT_FRAMES, I_PINS) +
      NEW_FRAME_SET_ARRAY ( STROBED_OUTPUT_FRAMES(TDELAY), O_PINS);

    constant DT_BASIS : Delay_Time_Basis := (FALSE, 0 ns, 0 ns, 
                                             TIMED_DELAY, 0, 0, 0);

    variable TD1 : Time_Data := NEW_TIME_DATA ( FSA );
    variable T1  : Wave_Timing := ((PERIOD, DT_BASIS), TD1);

    --        Order of signals:
    --
    --        (Y0, Y1, Y2, Y3, Y4, Y5, Y6, Y7,
    --         C, B, A, G1, G2A, G2B)
    --

    variable ALL_STATES_G1 : Wtime_Slice_List (1 to 11) := (
      (  "UUUUUUUU"
     & "UUUUUU", T1),

      (  "11111111"
     & "000000", T1), -- reset

      (  "U1111111"
     & "000U00", T1),

      (  "X1111111"
     & "000X00", T1),

      (  "11111111"
     & "000000", T1),

      (  "01111111"
     & "000100", T1),

      (  "X1111111"
     & "000Z00", T1),

      (  "X1111111"
     & "000W00", T1),

      (  "11111111"
     & "000L00", T1),

      (  "01111111"
     & "000H00", T1),

      (  "X1111111"
     & "000-00", T1)
      );



    variable ALL_STATES_G2A : Wtime_Slice_List (1 to 10) := (
      (  "11111111"
     & "000000", T1), -- reset

      (  "U1111111"
     & "0001U0", T1),

      (  "X1111111"
     & "0001X0", T1),

      (  "01111111"
     & "000100", T1),

      (  "11111111"
     & "000110", T1),

      (  "X1111111"
     & "0001Z0", T1),

      (  "X1111111"
     & "0001W0", T1),

      (  "01111111"
     & "0001L0", T1),

      (  "11111111"
     & "0001H0", T1),

      (  "X1111111"
     & "0001-0", T1)
      );



    variable ALL_STATES_G2B : Wtime_Slice_List (1 to 10) := (
      (  "11111111"
     & "000000", T1), -- reset

      (  "U1111111"
     & "00010U", T1),

      (  "X1111111"
     & "00010X", T1),

      (  "01111111"
     & "000100", T1),

      (  "11111111"
     & "000101", T1),

      (  "X1111111"
     & "00010Z", T1),

      (  "X1111111"
     & "00010W", T1),

      (  "01111111"
     & "00010L", T1),

      (  "11111111"
     & "00010H", T1),

      (  "X1111111"
     & "00010-", T1)
      );



    variable ALL_STATES_C : Wtime_Slice_List (1 to 10) := (
      (  "11111111"
     & "000000", T1), -- reset

      (  "U111U111"
     & "U00100", T1),

      (  "X111X111"
     & "X00100", T1),

      (  "01111111"
     & "000100", T1),

      (  "11110111"
     & "100100", T1),

      (  "X111X111"
     & "Z00100", T1),

      (  "X111X111"
     & "W00100", T1),

      (  "01111111"
     & "L00100", T1),

      (  "11110111"
     & "H00100", T1),

      (  "X111X111"
     & "-00100", T1)
      );



    variable ALL_STATES_B : Wtime_Slice_List (1 to 10) := (
      (  "11111111"
     & "000000", T1), -- reset

      (  "U1U11111"
     & "0U0100", T1),

      (  "X1X11111"
     & "0X0100", T1),

      (  "01111111"
     & "000100", T1),

      (  "11011111"
     & "010100", T1),

      (  "X1X11111"
     & "0Z0100", T1),

      (  "X1X11111"
     & "0W0100", T1),

      (  "01111111"
     & "0L0100", T1),

      (  "11011111"
     & "0H0100", T1),

      (  "X1X11111"
     & "0-0100", T1)
      );



    variable ALL_STATES_A : Wtime_Slice_List (1 to 10) := (
      (  "11111111"
     & "000000", T1), -- reset

      (  "UU111111"
     & "00U100", T1),

      (  "XX111111"
     & "00X100", T1),

      (  "01111111"
     & "000100", T1),

      (  "10111111"
     & "001100", T1),

      (  "XX111111"
     & "00Z100", T1),

      (  "XX111111"
     & "00W100", T1),

      (  "01111111"
     & "00L100", T1),

      (  "10111111"
     & "00H100", T1),

      (  "XX111111"
     & "00-100", T1)
      );



    variable TIMING_PARAMS : Wtime_Slice_List (1 to 10) := (
      (  "11111111"
     & "000000", T1), -- reset

      (  "01111111"
     & "000100", T1),

      (  "10111111"
     & "001100", T1), -- tplh_bs2

      (  "01111111"
     & "000100", T1), -- tphl_bs2

      (  "11111110"
     & "111100", T1), -- tphl_bs3

      (  "11111101"
     & "110100", T1), -- tplh_bs3

      (  "11111111"
     & "110000", T1), -- tplh_en3

      (  "11111101"
     & "110100", T1), -- tphl_en3

      (  "11111111"
     & "110101", T1), -- tplh_en2

      (  "11111101"
     & "110100", T1) -- tphl_en2
      );



    variable TRUTH_TABLE : Wtime_Slice_List (1 to 12) := (
      (  "11111111"
     & "000000", T1), -- reset

      (  "11111111"
     & "XXXX01", T1),

      (  "11111111"
     & "XXXX10", T1),

      (  "11111111"
     & "XXX0XX", T1),

      (  "01111111"
     & "000100", T1),

      (  "10111111"
     & "001100", T1),

      (  "11011111"
     & "010100", T1),

      (  "11101111"
     & "011100", T1),

      (  "11110111"
     & "100100", T1),

      (  "11111011"
     & "101100", T1),

      (  "11111101"
     & "110100", T1),

      (  "11111110"
     & "111100", T1)
      );



  begin
    assert FALSE
      report "ALL_STATES_G1 vectors"
        severity note;
      for I in ALL_STATES_G1' range loop
        APPLY(CONNECT,ALL_STATES_G1(I).CODES,ALL_STATES_G1(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_G2A vectors"
        severity note;
      for I in ALL_STATES_G2A' range loop
        APPLY(CONNECT,ALL_STATES_G2A(I).CODES,ALL_STATES_G2A(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_G2B vectors"
        severity note;
      for I in ALL_STATES_G2B' range loop
        APPLY(CONNECT,ALL_STATES_G2B(I).CODES,ALL_STATES_G2B(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_C vectors"
        severity note;
      for I in ALL_STATES_C' range loop
        APPLY(CONNECT,ALL_STATES_C(I).CODES,ALL_STATES_C(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_B vectors"
        severity note;
      for I in ALL_STATES_B' range loop
        APPLY(CONNECT,ALL_STATES_B(I).CODES,ALL_STATES_B(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_A vectors"
        severity note;
      for I in ALL_STATES_A' range loop
        APPLY(CONNECT,ALL_STATES_A(I).CODES,ALL_STATES_A(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "TIMING_PARAMS vectors"
        severity note;
      for I in TIMING_PARAMS' range loop
        APPLY(CONNECT,TIMING_PARAMS(I).CODES,TIMING_PARAMS(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "TRUTH_TABLE vectors"
        severity note;
      for I in TRUTH_TABLE' range loop
        APPLY(CONNECT,TRUTH_TABLE(I).CODES,TRUTH_TABLE(I).WTIME,ALL_PINS);
      end loop;

    end;

  ---------------------------------------------------------------------------
  --  The following procedure is used to provide test vectors for the model.
  --  The test vectors (inputs and expected outputs, along with the period
  --  of each slice) are read in from an external file.  The test vectors 
  --  are applied as follows:
  --
  --   Beginning of period:  Inputs set to appropriate values
  --                         Expected outputs set to "don't care"
  --
  --   After <START_TOLERANCE>:  Expected outputs set to appropriate values
  --
  --   After <FS_TIME - END_TOLERANCE>: Get next set of inputs and outputs
  --
  --   After <FS_TIME> (end of period): Get next set of inputs and outputs
  ---------------------------------------------------------------------------
    procedure SN54xx138_Test
    (
      signal CONNECT   : inout Waves_Port_List;
      constant INPUT_FILE_NAME  : String;
      constant START_TOLERANCE  : Time;
      constant END_TOLERANCE    : Time ) is

      variable TOLERANCE : Time := START_TOLERANCE + END_TOLERANCE;

      constant FSA : Frame_Set_Array :=
        NEW_FRAME_SET_ARRAY (INPUT_FRAMES, I_PINS) +
        NEW_FRAME_SET_ARRAY (OUTPUT_FRAMES, O_PINS);

      constant DT_BASIS : Delay_Time_Basis := (FALSE, 0 ns, 0 ns, 
                                               TIMED_DELAY, 0, 0, 0);

      variable TD : Time_Data := NEW_TIME_DATA (FSA);

      constant FSA_DONT_CARE : Frame_Set_Array :=
        NEW_FRAME_SET_ARRAY (INPUT_FRAMES, I_PINS) +
        NEW_FRAME_SET_ARRAY (DONT_CARE_FRAMES, O_PINS);

      variable TD_DONT_CARE : Time_Data := NEW_TIME_DATA (FSA_DONT_CARE);

      file INPUT_FILE : Text is in INPUT_FILE_NAME;

      -- the file slice must be allocated
      variable SN54xx138_FILE_SLICE : File_Slice := NEW_FILE_SLICE;

    begin

      loop
        READ_FILE_SLICE(INPUT_FILE, SN54xx138_FILE_SLICE);
        exit when SN54xx138_FILE_SLICE.END_OF_FILE;
        if SN54xx138_FILE_SLICE.FS_TIME > TOLERANCE then
          APPLY(CONNECT, SN54xx138_FILE_SLICE.CODES.all, 
                DELAY(START_TOLERANCE), TD_DONT_CARE);
          APPLY(CONNECT, SN54xx138_FILE_SLICE.CODES.all, 
                DELAY(SN54xx138_FILE_SLICE.FS_TIME - TOLERANCE), TD);
          APPLY(CONNECT, SN54xx138_FILE_SLICE.CODES.all, 
                DELAY(END_TOLERANCE), TD_DONT_CARE);
        else
          APPLY(CONNECT, SN54xx138_FILE_SLICE.CODES.all, 
                DELAY(SN54xx138_FILE_SLICE.FS_TIME), TD);
        end if;
      end loop;
    end;
end WGENERATOR_SN54xx138;
