-- Filename : waves_device_SN54xx138.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is ( TP_Y0, TP_Y1, TP_Y2, TP_Y3, TP_Y4, TP_Y5, TP_Y6, TP_Y7,
                      TP_C, TP_B, TP_A, TP_G1, TP_G2A, TP_G2B);


  constant DEVICE_ID : String := "SN54xx138";

  -- The following declaration is just for documentation purposes.

  constant PIN_DIRECTION : Direction_List := (Response,   -- TP_Y0
                                              Response,   -- TP_Y1
                                              Response,   -- TP_Y2
                                              Response,   -- TP_Y3
                                              Response,   -- TP_Y4
                                              Response,   -- TP_Y5
                                              Response,   -- TP_Y6
                                              Response,   -- TP_Y7
                                              Stimulus,   -- TP_A
                                              Stimulus,   -- TP_B
                                              Stimulus,   -- TP_C
                                              Stimulus,   -- TP_G1
                                              Stimulus,   -- TP_G2A
                                              Stimulus);  -- TP_G2B
        
  function PIN_NAME (PIN : Test_Pins) return String;

end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_Y0    => return "Y0";
      when TP_Y1    => return "Y1";
      when TP_Y2    => return "Y2";
      when TP_Y3    => return "Y3";
      when TP_Y4    => return "Y4";
      when TP_Y5    => return "Y5";
      when TP_Y6    => return "Y6";
      when TP_Y7    => return "Y7";
      when TP_C     => return "C";
      when TP_B     => return "B";
      when TP_A     => return "A";
      when TP_G1    => return "G1";
      when TP_G2A   => return "G2A";
      when TP_G2B   => return "G2B";
    end case;
  end;
end WAVES_DEVICE;

