-- Filename : SN54xx138_TB_CON.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library STD_PACK;
  use STD_PACK.SIMFLAG.all;    -- Global simulation options
  use STD_PACK.TTL_TIMING.all; -- TTL derating coefficients

library SN54xx138;
  use SN54xx138.SN54xx138_TIMING.all;  -- timing module

configuration SN54xx138_TB_CON of SN54xx138_TB is

for TEST_BENCH
  for UNDER_TEST : DUT use entity SN54xx138.SN54xx138_DIP16(STRUCTURAL)
    generic map (
      DIP_TIME_MODE => TYPICAL,      -- MIN, TYP, or MAX
      DIP_FAMILY    => S_FAMILY,     -- S or LS
      DIP_VCC       => 5.0,          -- Volts
      DIP_TA        => 25.0,         -- degrees Celsius
      DIP_DFACTOR   => 100.0,        -- percent
      DIP_REF       => "SN54xx138",  -- component reference designator

      TWD_A   => 0 ns,  -- back-annotated input wire delays
      TWD_B   => 0 ns,
      TWD_C   => 0 ns,
      TWD_G1  => 0 ns,
      TWD_G2A => 0 ns,
      TWD_G2B => 0 ns,

      CL_Y0 => 15.0,   -- back-annotated output loading (picofarads)
      CL_Y1 => 15.0,   -- (timing module will adjust time accordingly)
      CL_Y2 => 15.0,
      CL_Y3 => 15.0,
      CL_Y4 => 15.0,
      CL_Y5 => 15.0,
      CL_Y6 => 15.0,
      CL_Y7 => 15.0
    );

  end for;
end for;        

end SN54xx138_TB_CON ;
