-- Filename : SN54xx138_DIP16.vhd
--
-- Version 2.1
--
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--      
--
-- Part Name:          SN54xx138
-- Manufacturer:       Texas Instruments
-- Other Sources:      Advanced Micro Devices
-- Reference:          Data Sheet - The 1988 TTL Data Book (p. 2-429)
-- Packaging:          J Suffix (ceramic 16 pin DIP), or
--                     W Suffix (ceramic flat package)
--
-- Description:       The bipolar SSI SN54xx138 is a 3 to 8 line decoder.
--                    The '138 decodes one of eight lines dependent on the
--                    conditions at the three binary select inputs and the three
--                    enable inputs. Two active-low and one active-high enable
--                    inputs reduce the need for external gates or inverters
--                    when expanding.
--
--                    The '54 series meets military specifications.
--
-- Developer:         Institute for Technology Development
--                    VHDL Modeling Group
--                    1 Research Boulevard, Suite 205
--                    Starkville, MS 39759
--
-- Contact:           Dan Johnson
--                    CAD Section Manager
--                    (601) 325-2240
--                    danj@itd.msstate.edu
--
-- Version            2.1
-- Date:              07-12-91
--
-- Date of Formal
-- Verification:      TBD
--
--
--        ------------------------------------------------------------------
--
--
-- Recommended operating conditions:
--
--   S_FAMILY
--    _____________________________________________
--   |      |  minimum  nominal  maximum  |  unit  |
--   |______|_____________________________|________|
--   | VCC  |  4.5      5.0      5.5      | V      |
--   | VIH  |  2.0                        | V      |
--   | VIL  |                    0.8      | V      |
--   | IOH  |                   -1.0      | mA     |
--   | IOL  |                     20      | mA     |
--   | TA   | -55        25      125      | deg. C |
--   |______|_____________________________|________|
--
--
--   LS_FAMILY
--    _____________________________________________
--   |      |  minimum  nominal  maximum  |  unit  |
--   |______|_____________________________|________|
--   | VCC  |  4.5      5.0      5.5      | V      |
--   | VIH  |  2.0                        | V      |
--   | VIL  |                    0.7      | V      |
--   | IOH  |                   -0.4      | mA     |
--   | IOL  |                      4      | mA     |
--   | TA   | -55        25      125      | deg. C |
--   |______|_____________________________|________|
--
--
-- Worst case operating conditions:
--    _________________________________
--   |        | voltage   temperature  |
--   | _______|________________________|
--   | tphl   | 5.5 V     -55 deg. C   |
--   | tplh   | 4.5 V     125 deg. C   |
--   |________|________________________|
--
-- Note: High capacitive loading also degrades propagation delays of the part.


library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all ;   -- Defines logic types, operators, functions

library STD_PACK ;                  -- Standard library for all models
  use STD_PACK.SIMFLAG.all;         -- Global simulation options
  use STD_PACK.TTL_TIMING.all;      -- TTL derating coefficients

library SN54xx138;
  use SN54xx138.SN54xx138_TIMING.all;  -- timing module

------------------------------------------------------------

entity SN54xx138_DIP16 is 

generic
  (
    DIP_TIME_MODE : Time_Modes := TYPICAL;
    DIP_FAMILY    : Tech_Type  := STD_FAMILY;
    DIP_VCC       : Real       := VCC;
    DIP_TA        : Real       := TA;
    DIP_DFACTOR   : Real       := DERATE_FACTOR;
    DIP_REF       : String     := "SN54xx138"; 

    TWD_A   : Time := 0 ns;
    TWD_B   : Time := 0 ns;
    TWD_C   : Time := 0 ns;
    TWD_G1  : Time := 0 ns;
    TWD_G2A : Time := 0 ns;
    TWD_G2B : Time := 0 ns;

    CL_Y0 : Real := 15.0; -- pf
    CL_Y1 : Real := 15.0; -- pf
    CL_Y2 : Real := 15.0; -- pf
    CL_Y3 : Real := 15.0; -- pf
    CL_Y4 : Real := 15.0; -- pf
    CL_Y5 : Real := 15.0; -- pf
    CL_Y6 : Real := 15.0; -- pf
    CL_Y7 : Real := 15.0 -- pf

  );

port(
     Y0    : out Std_Ulogic ;
     Y1    : out Std_Ulogic ;
     Y2    : out Std_Ulogic ;
     Y3    : out Std_Ulogic ;
     Y4    : out Std_Ulogic ;
     Y5    : out Std_Ulogic ;
     Y6    : out Std_Ulogic ;
     Y7    : out Std_Ulogic ;
  
     A     : in Std_Ulogic ;
     B     : in Std_Ulogic ;
     C     : in Std_Ulogic ;
     G1    : in Std_Ulogic ;
     G2A   : in Std_Ulogic ;
     G2B   : in Std_Ulogic ;

     VCC    : in Real := 5.0;
     GND    : in Real := 0.0
  );

   -- pin mapping

   attribute PIN_NO         : positive ;
   attribute PIN_NO of A    : signal is 1 ;
   attribute PIN_NO of B    : signal is 2 ;
   attribute PIN_NO of C    : signal is 3 ;
   attribute PIN_NO of G2A  : signal is 4 ;
   attribute PIN_NO of G2B  : signal is 5 ;
   attribute PIN_NO of G1   : signal is 6 ;
   attribute PIN_NO of Y7   : signal is 7 ;
   attribute PIN_NO of GND  : signal is 8 ;
   attribute PIN_NO of Y6   : signal is 9 ;
   attribute PIN_NO of Y5   : signal is 10 ;
   attribute PIN_NO of Y4   : signal is 11 ;
   attribute PIN_NO of Y3   : signal is 12 ;
   attribute PIN_NO of Y2   : signal is 13 ;
   attribute PIN_NO of Y1   : signal is 14 ;
   attribute PIN_NO of Y0   : signal is 15 ;
   attribute PIN_NO of VCC  : signal is 16 ;

end SN54xx138_DIP16;

-- ======================================================================

architecture STRUCTURAL of SN54xx138_DIP16 is

  component DECODER

  generic
  (
     GEN_PROP_TIMES  : Prop_Times := GET_TIMING(DIP_FAMILY,
                                                DIP_TIME_MODE,
                                                DIP_VCC,
                                                DIP_TA,
                                                DIP_DFACTOR);
    GEN_FAMILY : Tech_Type := DIP_FAMILY;

    TWD_A   : Time := 0.0 ns;    -- wire delays for each input pin
    TWD_B   : Time := 0.0 ns;
    TWD_C   : Time := 0.0 ns;
    TWD_G1  : Time := 0.0 ns;
    TWD_G2A : Time := 0.0 ns;
    TWD_G2B : Time := 0.0 ns;

    CL_Y0 : REAL := 15.0;       -- fanout capacitance seen by output (in pf)
    CL_Y1 : REAL := 15.0;
    CL_Y2 : REAL := 15.0;
    CL_Y3 : REAL := 15.0;
    CL_Y4 : REAL := 15.0;
    CL_Y5 : REAL := 15.0;
    CL_Y6 : REAL := 15.0;
    CL_Y7 : REAL := 15.0;

    REF : String := DIP_REF
  );

  port (
       Y0    : out Std_Ulogic;
       Y1    : out Std_Ulogic;
       Y2    : out Std_Ulogic;
       Y3    : out Std_Ulogic;
       Y4    : out Std_Ulogic;
       Y5    : out Std_Ulogic;
       Y6    : out Std_Ulogic;
       Y7    : out Std_Ulogic;
    
       A     : in Std_Ulogic;
       B     : in Std_Ulogic;
       C     : in Std_Ulogic;
       G1    : in Std_Ulogic;
       G2A   : in Std_Ulogic;
       G2B   : in Std_Ulogic
   );

  end component;

  for PART1 : DECODER use entity SN54xx138.SN54xx138(BEHAVIORAL);

begin

  assert ((VCC - GND > 4.5) and (VCC - GND < 5.5)) report
    "**** VCC and GND not connected properly ****" severity error;

----------------------------------------

  PART1: DECODER
  generic map(
    TWD_A   => TWD_A,
    TWD_B   => TWD_B,
    TWD_C   => TWD_C,
    TWD_G1  => TWD_G1,
    TWD_G2A => TWD_G2A,
    TWD_G2B => TWD_G2B,

    CL_Y0  => CL_Y0,
    CL_Y1  => CL_Y1,
    CL_Y2  => CL_Y2,
    CL_Y3  => CL_Y3,
    CL_Y4  => CL_Y4,
    CL_Y5  => CL_Y5,
    CL_Y6  => CL_Y6,
    CL_Y7  => CL_Y7
  )
  port map (
     Y0    => Y0,
     Y1    => Y1,
     Y2    => Y2,
     Y3    => Y3,
     Y4    => Y4,
     Y5    => Y5,
     Y6    => Y6,
     Y7    => Y7,

     A     => A,
     B     => B,
     C     => C,
     G1    => G1,
     G2A   => G2A,
     G2B   => G2B
  ) ;

----------------------------------------

end STRUCTURAL;



