-- Filename : waves_device_SN54xx112A.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is ( TP_Q1, TP_QB1, TP_Q2, TP_QB2,
                      TP_CLK1, TP_J1, TP_K1, TP_PR1, TP_CLR1, 
                      TP_CLK2, TP_J2, TP_K2, TP_PR2, TP_CLR2);


  constant DEVICE_ID : string := "SN54XX112A";

  -- The following declaration is just for documentation purposes.

  constant PIN_DIRECTION : Direction_List := (Response,   -- TP_Q1
                                              Response,   -- TP_QB1
                                              Response,   -- TP_Q2
                                              Response,   -- TP_QB2
                                              Stimulus,   -- TP_CLK1
                                              Stimulus,   -- TP_J1
                                              Stimulus,   -- TP_K1
                                              Stimulus,   -- TP_PR1
                                              Stimulus,   -- TP_CLR1
                                              Stimulus,   -- TP_CLK2
                                              Stimulus,   -- TP_J2
                                              Stimulus,   -- TP_K2
                                              Stimulus,   -- TP_PR2
                                              Stimulus);  -- TP_CLR2)
        
  function PIN_NAME (PIN : Test_Pins) return String;
    
end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_Q1    => return "Q1";
      when TP_QB1   => return "QB1";
      when TP_Q2    => return "Q2";
      when TP_QB2   => return "QB2";
      when TP_CLK1  => return "CLK1";
      when TP_J1    => return "J1";
      when TP_K1    => return "K1";
      when TP_PR1   => return "PR1";
      when TP_CLR1  => return "CLR1";
      when TP_CLK2  => return "CLK2";
      when TP_J2    => return "J2";
      when TP_K2    => return "K2";
      when TP_PR2   => return "PR2";
      when TP_CLR2  => return "CLR2";
    end case;
  end;
end WAVES_DEVICE;

