-- Filename : wgenerator_SN54xx11.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
  use STD.TEXTIO.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_SYSTEM.all;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library SN54xx11;
  use SN54xx11.WAVES_DEVICE.all;
  use SN54xx11.WAVES_OBJECTS.all;
  use SN54xx11.WAVES_FRAMES.all;
  use SN54xx11.WAVES_UTILITIES.all;
 
package WGENERATOR_SN54xx11 is
  procedure SN54xx11_TEST
  (
    signal CONNECT   : inout Waves_Port_List
  );

  procedure SN54xx11_TEST
  (
    signal CONNECT            : inout Waves_Port_List;
    constant INPUT_FILE_NAME  : String;
    constant START_TOLERANCE  : Time;
    constant END_TOLERANCE    : Time 
  );

end WGENERATOR_SN54xx11;

-- ======================================================================

package body WGENERATOR_SN54xx11 is

    constant O_PINS : Pinset := NEW_PINSET(( TP_Y1, TP_Y2, TP_Y3));
    constant I_PINS : Pinset := ALL_PINS and not O_PINS;
    constant EMPTY_EVENT : Integer := -1;

  ---------------------------------------------------------------------------
  --  The following procedure is used to provide test vectors for the model.
  --  The test vectors (inputs and expected outputs) are contained within
  --  the procedure, and are analyzed with the VHDL code.  The test vectors
  --  are applied as follows:
  --
  --   Beginning of period:  Inputs set to appropriate values
  --                         Expected outputs set to "don't care"
  --
  --   After 95 ns (95% of period):  Expected outputs set to appropriate values
  --
  --   After 100 ns (end of period): Get next set of inputs and outputs
  ---------------------------------------------------------------------------
  procedure SN54xx11_TEST(
    signal CONNECT   : inout Waves_Port_List) is

    constant PERIOD          : Time       := 100 ns;
    constant UNCERTAINTY_PCT : Real       := 0.95;
    constant TDELAY          : Event_Time := ETIME (UNCERTAINTY_PCT * PERIOD);

    constant FSA : Frame_Set_Array := 
      NEW_FRAME_SET_ARRAY ( INPUT_FRAMES, I_PINS) +
      NEW_FRAME_SET_ARRAY ( STROBED_OUTPUT_FRAMES(TDELAY), O_PINS);

    constant DT_BASIS : Delay_Time_Basis := (FALSE, 0 ns, 0 ns, 
                                             TIMED_DELAY, 0, 0, 0);

    variable TD1 : Time_Data := NEW_TIME_DATA ( FSA );
    variable T1  : Wave_Timing := ((PERIOD, DT_BASIS), TD1);

    --        Order of signals:
    --
    --        (Y1, Y2, Y3,
    --         A1, B1, C1, A2, B2, C2, A3, B3, C3)
    --

    variable ALL_STATES_PART1 : Wtime_Slice_List (1 to 29) := (
      (  "UUU"
     & "UUUUUUUUU", T1),

      (  "000"
     & "000000000", T1), -- reset to normal

      (  "UUU"
     & "11UUUUUUU", T1), -- 9 states => A1, B1, & C1 inputs

      (  "XUU"
     & "11XUUUUUU", T1),

      (  "0UU"
     & "110UUUUUU", T1),

      (  "1UU"
     & "111UUUUUU", T1),

      (  "XUU"
     & "11ZUUUUUU", T1),

      (  "XUU"
     & "11WUUUUUU", T1),

      (  "0UU"
     & "11LUUUUUU", T1),

      (  "1UU"
     & "11HUUUUUU", T1),

      (  "XUU"
     & "11-UUUUUU", T1),

      (  "UUU"
     & "1U1UUUUUU", T1),

      (  "XUU"
     & "1X1UUUUUU", T1),

      (  "0UU"
     & "101UUUUUU", T1),

      (  "1UU"
     & "111UUUUUU", T1),

      (  "XUU"
     & "1Z1UUUUUU", T1),

      (  "XUU"
     & "1W1UUUUUU", T1),

      (  "0UU"
     & "1L1UUUUUU", T1),

      (  "1UU"
     & "1H1UUUUUU", T1),

      (  "XUU"
     & "1-1UUUUUU", T1),

      (  "UUU"
     & "U11UUUUUU", T1),

      (  "XUU"
     & "X11UUUUUU", T1),

      (  "0UU"
     & "011UUUUUU", T1),

      (  "1UU"
     & "111UUUUUU", T1),

      (  "XUU"
     & "Z11UUUUUU", T1),

      (  "XUU"
     & "W11UUUUUU", T1),

      (  "0UU"
     & "L11UUUUUU", T1),

      (  "1UU"
     & "H11UUUUUU", T1),

      (  "XUU"
     & "-11UUUUUU", T1)
      );



    variable ALL_STATES_PART2 : Wtime_Slice_List (1 to 27) := (
      (  "UUU"
     & "UUU11UUUU", T1), -- 9 states => A2, B2, & C2 inputs

      (  "UXU"
     & "UUU11XUUU", T1), 

      (  "U0U"
     & "UUU110UUU", T1),

      (  "U1U"
     & "UUU111UUU", T1),

      (  "UXU"
     & "UUU11ZUUU", T1),

      (  "UXU"
     & "UUU11WUUU", T1),

      (  "U0U"
     & "UUU11LUUU", T1),

      (  "U1U"
     & "UUU11HUUU", T1),

      (  "UXU"
     & "UUU11-UUU", T1),

      (  "UUU"
     & "UUU1U1UUU", T1),

      (  "UXU"
     & "UUU1X1UUU", T1),

      (  "U0U"
     & "UUU101UUU", T1),

      (  "U1U"
     & "UUU111UUU", T1),

      (  "UXU"
     & "UUU1Z1UUU", T1),

      (  "UXU"
     & "UUU1W1UUU", T1),

      (  "U0U"
     & "UUU1L1UUU", T1),

      (  "U1U"
     & "UUU1H1UUU", T1),

      (  "UXU"
     & "UUU1-1UUU", T1),

      (  "UUU"
     & "UUUU11UUU", T1),

      (  "UXU"
     & "UUUX11UUU", T1),

      (  "U0U"
     & "UUU011UUU", T1),

      (  "U1U"
     & "UUU111UUU", T1),

      (  "UXU"
     & "UUUZ11UUU", T1),

      (  "UXU"
     & "UUUW11UUU", T1),

      (  "U0U"
     & "UUUL11UUU", T1),

      (  "U1U"
     & "UUUH11UUU", T1),

      (  "UXU"
     & "UUU-11UUU", T1)
      );



    variable ALL_STATES_PART3 : Wtime_Slice_List (1 to 27) := (
      (  "UUU"
     & "UUUUUU11U", T1), -- 9 states => A3, B3, & C3 inputs

      (  "UUX"
     & "UUUUUU11X", T1),

      (  "UU0"
     & "UUUUUU110", T1),

      (  "UU1"
     & "UUUUUU111", T1),

      (  "UUX"
     & "UUUUUU11Z", T1),

      (  "UUX"
     & "UUUUUU11W", T1),

      (  "UU0"
     & "UUUUUU11L", T1),

      (  "UU1"
     & "UUUUUU11H", T1),

      (  "UU-"
     & "UUUUUU11-", T1),

      (  "UUU"
     & "UUUUUU1U1", T1),

      (  "UUX"
     & "UUUUUU1X1", T1),

      (  "UU0"
     & "UUUUUU101", T1),

      (  "UU1"
     & "UUUUUU111", T1),

      (  "UUX"
     & "UUUUUU1Z1", T1),

      (  "UUX"
     & "UUUUUU1W1", T1),

      (  "UU0"
     & "UUUUUU1L1", T1),

      (  "UU1"
     & "UUUUUU1H1", T1),

      (  "UUX"
     & "UUUUUU1-1", T1),

      (  "UUU"
     & "UUUUUUU11", T1),

      (  "UUX"
     & "UUUUUUX11", T1),

      (  "UU0"
     & "UUUUUU011", T1),

      (  "UU1"
     & "UUUUUU111", T1),

      (  "UUX"
     & "UUUUUUZ11", T1),

      (  "UUX"
     & "UUUUUUW11", T1),

      (  "UU0"
     & "UUUUUUL11", T1),

      (  "UU1"
     & "UUUUUUH11", T1),

      (  "UUX"
     & "UUUUUU-11", T1)
      );



    variable TIMING_PARAMS : Wtime_Slice_List (1 to 4) := (
      (  "000"
     & "000000000", T1), -- reset to normal

      (  "000"
     & "000000000", T1), -- timing parameters

      (  "111"
     & "111111111", T1), -- tplh

      (  "000"
     & "000000000", T1) -- tphl
      );



    variable TRUTH_TABLE : Wtime_Slice_List (1 to 5) := (
      (  "000"
     & "000000000", T1), -- reset to normal

      (  "111"
     & "111111111", T1), -- truth table

      (  "000"
     & "0XX0XX0XX", T1),

      (  "000"
     & "X0XX0XX0X", T1),

      (  "000"
     & "XX0XX0XX0", T1)
      );



  begin
    assert FALSE
      report "ALL_STATES_PART1 vectors"
        severity note;
      for I in ALL_STATES_PART1' range loop
        APPLY(CONNECT,ALL_STATES_PART1(I).CODES,ALL_STATES_PART1(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_PART2 vectors"
        severity note;
      for I in ALL_STATES_PART2' range loop
        APPLY(CONNECT,ALL_STATES_PART2(I).CODES,ALL_STATES_PART2(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_PART3 vectors"
        severity note;
      for I in ALL_STATES_PART3' range loop
        APPLY(CONNECT,ALL_STATES_PART3(I).CODES,ALL_STATES_PART3(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "TIMING_PARAMS vectors"
        severity note;
      for I in TIMING_PARAMS' range loop
        APPLY(CONNECT,TIMING_PARAMS(I).CODES,TIMING_PARAMS(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "TRUTH_TABLE vectors"
        severity note;
      for I in TRUTH_TABLE' range loop
        APPLY(CONNECT,TRUTH_TABLE(I).CODES,TRUTH_TABLE(I).WTIME,ALL_PINS);
      end loop;

    end;

  ---------------------------------------------------------------------------
  --  The following procedure is used to provide test vectors for the model.
  --  The test vectors (inputs and expected outputs, along with the period
  --  of each slice) are read in from an external file.  The test vectors 
  --  are applied as follows:
  --
  --   Beginning of period:  Inputs set to appropriate values
  --                         Expected outputs set to "don't care"
  --
  --   After <START_TOLERANCE>:  Expected outputs set to appropriate values
  --
  --   After <FS_TIME - END_TOLERANCE>: Get next set of inputs and outputs
  --
  --   After <FS_TIME> (end of period): Get next set of inputs and outputs
  ---------------------------------------------------------------------------
    procedure SN54xx11_Test
    (
      signal CONNECT            : inout Waves_Port_List;
      constant INPUT_FILE_NAME  : String;
      constant START_TOLERANCE  : Time;
      constant END_TOLERANCE    : Time ) is

      variable TOLERANCE : Time := START_TOLERANCE + END_TOLERANCE;

      constant FSA : Frame_Set_Array :=
        NEW_FRAME_SET_ARRAY (INPUT_FRAMES, I_PINS) +
        NEW_FRAME_SET_ARRAY (OUTPUT_FRAMES, O_PINS);

      constant DT_BASIS : Delay_Time_Basis := (FALSE, 0 ns, 0 ns, TIMED_DELAY, 0, 0, 0);

      variable TD : Time_Data := NEW_TIME_DATA (FSA);

      constant FSA_DONT_CARE : Frame_Set_Array :=
        NEW_FRAME_SET_ARRAY (INPUT_FRAMES, I_PINS) +
        NEW_FRAME_SET_ARRAY (DONT_CARE_FRAMES, O_PINS);

      variable TD_DONT_CARE : Time_Data := NEW_TIME_DATA (FSA_DONT_CARE);

      file INPUT_FILE : Text is in INPUT_FILE_NAME;

      -- the file slice must be allocated
      variable SN54xx11_FILE_SLICE : File_Slice := NEW_FILE_SLICE;

    begin
      loop
        READ_FILE_SLICE(INPUT_FILE, SN54xx11_FILE_SLICE);
        exit when SN54xx11_FILE_SLICE.END_OF_FILE;
        if SN54xx11_FILE_SLICE.FS_TIME > TOLERANCE then
          APPLY(CONNECT, SN54xx11_FILE_SLICE.CODES.all, 
                DELAY(START_TOLERANCE), TD_DONT_CARE);
          APPLY(CONNECT, SN54xx11_FILE_SLICE.CODES.all, 
                DELAY(SN54xx11_FILE_SLICE.FS_TIME - TOLERANCE), TD);
          APPLY(CONNECT, SN54xx11_FILE_SLICE.CODES.all, 
                DELAY(END_TOLERANCE), TD_DONT_CARE);
        else
          APPLY(CONNECT, SN54xx11_FILE_SLICE.CODES.all, 
                DELAY(SN54xx11_FILE_SLICE.FS_TIME), TD);
        end if;
      end loop;
    end;
end WGENERATOR_SN54xx11;
