-- Filename : waves_device_SN54xx11.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library WAVES_STANDARD;
use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is ( TP_Y1, TP_Y2, TP_Y3, TP_A1, TP_B1, TP_C1,TP_A2, TP_B2, 
                      TP_C2, TP_A3, TP_B3, TP_C3);

  constant DEVICE_ID : string := "SN54xx11";

  -- The following declaration is just for documentation purposes.

  constant PIN_DIRECTION : Direction_List := (Response,   -- TP_Y1
                                              Response,   -- TP_Y2
                                              Response,   -- TP_Y3
                                              Stimulus,   -- TP_A1
                                              Stimulus,   -- TP_B1
                                              Stimulus,   -- TP_C1
                                              Stimulus,   -- TP_A2
                                              Stimulus,   -- TP_B2
                                              Stimulus,   -- TP_C2
                                              Stimulus,   -- TP_A3
                                              Stimulus,   -- TP_B3
                                              Stimulus);  -- TP_C3)
        
  function PIN_NAME (PIN : Test_Pins) return String;
    
end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_Y1    => return "Y1";
      when TP_Y2    => return "Y2";
      when TP_Y3    => return "Y3";
      when TP_A1    => return "A1";
      when TP_B1    => return "B1";
      when TP_C1    => return "C1";
      when TP_A2    => return "A2";
      when TP_B2    => return "B2";
      when TP_C2    => return "C2";
      when TP_A3    => return "A3";
      when TP_B3    => return "B3";
      when TP_C3    => return "C3";
    end case;
  end;
end WAVES_DEVICE;

