-- Filename : SN54xx109_TB_CON.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library STD_PACK;
  use STD_PACK.SIMFLAG.all;    -- Global simulation options
  use STD_PACK.TTL_TIMING.all; -- TTL derating coefficients

library SN54XX109;
use SN54XX109.SN54XX109_TIMING.all;  -- timing module

configuration SN54xx109_TB_CON of SN54xx109_TB is

  for TEST_BENCH
    for UNDER_TEST : DUT use entity SN54xx109.SN54xx109_DIP16(STRUCTURAL)
      generic map (
        DIP_TIME_MODE   => TYPICAL,
        DIP_XGEN        => TRUE,
        DIP_TIMING_MESG => TRUE,
        DIP_FAMILY      => STD_FAMILY,
        DIP_VCC         => 5.0,   -- Volts
        DIP_TA          => 25.0,  -- degrees Celsius
        DIP_DFACTOR     => 100.0, -- percent
        DIP_REF         => "SN54xx109",
    
        TWD_CLK1 => 0.0 ns,    -- wire delays for each input pin
        TWD_CLK2 => 0.0 ns, 
        TWD_J1   => 0.0 ns,
        TWD_J2   => 0.0 ns,
        TWD_K1   => 0.0 ns,
        TWD_K2   => 0.0 ns,
        TWD_PR1  => 0.0 ns,
        TWD_PR2  => 0.0 ns,
        TWD_CLR1 => 0.0 ns,
        TWD_CLR2 => 0.0 ns,

        CL_Q1   => 15.0, -- pf
        CL_QB1  => 15.0, -- pf
        CL_Q2   => 15.0, -- pf
        CL_QB2  => 15.0  -- pf
      );

    end for;
  end for;        

end SN54xx109_TB_CON;
