-- Filename : SN54xx109_DIP16.vhd
--
-- Version 2.1
--
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--      
----------------------------------------------------------------------------
--
-- Part Name:         SN54xx109
-- Manufacturer:      Texas Instruments
-- Other Sources:     Motorola
-- Reference:         Data Sheet - The 1973 TTL Data Book (p. 130-131)
-- Packaging:         J Suffix (ceramic 14 pin DIP), or
--                    W Suffix (ceramic flat package)
--
-- Description:       The bipolar SSI SN54xx109 is a dual J-K
--                    positive-edge-triggered flip-flop with preset and clear.
--                    A low-level at the preset or clear inputs sets or resets
--                    the outputs regardless of the levels of the other inputs.
--                    When preset and clear are in-active (high), data at the
--                    J and K' inputs meeting the setup time requirements are
--                    are transferred to the outputs on the positive-going edge
--                    of the clock pulse.  Following the hold time interval,
--                    data at the J and K' inputs may be changed without
--                    affecting the levels at the outputs.  These versatile
--                    flip-flops can perform as toggle flip-flops by ground K'
--                    and tying J high.  They also can perform as D-type
--                    flip-flops if J and K' are tied together.  The '54 series
--                    meets military specifications.
--
-- Developer:         Institute for Technology Development
--                    VHDL Modeling Group
--                    1 Research Boulevard, Suite 205
--                    Starkville, MS 39759
--
-- Contact:           Dan Johnson
--                    CAD Section Manager
--                    (601) 325-2240
--                    danj@itd.msstate.edu
--
-- Version            2.1
-- Date:              07-12-91
--
-- Date of Formal
-- Verification:      TBD
--
--
--        ------------------------------------------------------------------
--
--
-- Recommended operating conditions:
--
--   STD_FAMILY
--    _____________________________________________
--   |      |  minimum  nominal  maximum  |  unit  |
--   |______|_____________________________|________|
--   | VCC  |  4.5      5.0      5.5      | V      |
--   | VIH  |  2.0                        | V      |
--   | VIL  |                    0.8      | V      |
--   | IOH  |                   -0.8      | mA     |
--   | IOL  |                    16       | mA     |
--   | TW   |  20                         | ns     |
--   | TSU  |  10                         | mA     |
--   | TH   |  6                          | na     |
--   | TA   | -55        25      125      | deg. C |
--   |______|_____________________________|________|
--
--
--
-- Worst case operating conditions:
--    _________________________________
--   |        | voltage   temperature  |
--   | _______|________________________|
--   | tphl   | 5.5 V     -55 deg. C   |
--   | tplh   | 4.5 V     125 deg. C   |
--   |________|________________________|
--
-- Note: High capacitive loading also degrades propagation delays of the part.



library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;       -- Defines logic types, operators, function
  
library STD_PACK ;                  -- Standard library for all models
  use STD_PACK.SIMFLAG.all;         -- Global simulation parameters
  use STD_PACK.TTL_TIMING.all;      -- Environmental derating coefficients

library SN54xx109;
  use SN54xx109.SN54xx109_TIMING.all;  -- Timing module

------------------------------------------------------------
entity SN54xx109_DIP16 is 

  generic
    -- simulation defaults are from SIMFLAG package
  (
    DIP_TIME_MODE   : Time_Modes := TYPICAL;
    DIP_XGEN        : Boolean    := X_GEN;
    DIP_TIMING_MESG : Boolean    := TIMING_MESG;
    DIP_FAMILY      : Tech_Type  := STD_FAMILY;
    DIP_VCC         : Real       := VCC;
    DIP_TA          : Real       := TA;
    DIP_DFACTOR     : Real       := DERATE_FACTOR;
    DIP_REF         : String     := "SN54xx109";

    TWD_CLK1 : Time := 0.0 ns;    -- wire delays for each input pin
    TWD_CLK2 : Time := 0.0 ns;
    TWD_J1   : Time := 0.0 ns;
    TWD_J2   : Time := 0.0 ns;
    TWD_K1   : Time := 0.0 ns;
    TWD_K2   : Time := 0.0 ns;
    TWD_PR1  : Time := 0.0 ns;
    TWD_PR2  : Time := 0.0 ns;
    TWD_CLR1 : Time := 0.0 ns;
    TWD_CLR2 : Time := 0.0 ns;

    CL_Q1   : Real := 15.0; -- pf
    CL_QB1  : Real := 15.0; -- pf
    CL_Q2   : Real := 15.0; -- pf
    CL_QB2  : Real := 15.0  -- pf
  );

  port(
     Q1    : out Std_Ulogic ;
     QB1   : out Std_Ulogic ;
     Q2    : out Std_Ulogic ;
     QB2   : out Std_Ulogic ;

     CLK1  : in Std_Ulogic ;
     J1    : in Std_Ulogic ;
     K1    : in Std_Ulogic ;
     PR1   : in Std_Ulogic ;
     CLR1  : in Std_Ulogic ;
     CLK2  : in Std_Ulogic ;
     J2    : in Std_Ulogic ;
     K2    : in Std_Ulogic ;
     PR2   : in Std_Ulogic ;
     CLR2  : in Std_Ulogic ;

     VCC   : in Real := 5.0;  -- volts
     GND   : in Real := 0.0   -- volts
     ) ;

     -- Pin Mapping for J, N, or W package

     attribute PIN_NO          : positive ;
     attribute PIN_NO of CLK1  : signal is 1 ;
     attribute PIN_NO of K1    : signal is 2 ;
     attribute PIN_NO of J1    : signal is 3 ;
     attribute PIN_NO of PR1   : signal is 4 ;
     attribute PIN_NO of Q1    : signal is 5 ;
     attribute PIN_NO of QB1   : signal is 6 ;
     attribute PIN_NO of QB2   : signal is 7 ;
     attribute PIN_NO of GND   : signal is 8 ;
     attribute PIN_NO of Q2    : signal is 9 ;
     attribute PIN_NO of PR2   : signal is 10 ;
     attribute PIN_NO of J2    : signal is 11 ;
     attribute PIN_NO of K2    : signal is 12 ;
     attribute PIN_NO of CLK2  : signal is 13 ;
     attribute PIN_NO of CLR2  : signal is 14 ;
     attribute PIN_NO of CLR1  : signal is 15 ;
     attribute PIN_NO of VCC   : signal is 16 ;

end SN54xx109_DIP16;

------------------------------------------------------------
architecture STRUCTURAL of SN54xx109_DIP16 is

  component JKFF
  
  generic
  (
     GEN_PROP_TIMES  : Prop_Times := GET_TIMING(DIP_FAMILY,
                                                DIP_TIME_MODE,
                                                DIP_VCC,
                                                DIP_TA,
                                                DIP_DFACTOR);
       GEN_XGEN        : Boolean    := DIP_XGEN;
       GEN_TIMING_MESG : Boolean    := DIP_TIMING_MESG;
       GEN_FAMILY      : Tech_Type  := DIP_FAMILY;  
       GEN_TW_CLK      : Time       := TW_CLK (DIP_FAMILY);
       GEN_TW_POC_LO   : Time       := TW_POC_LO (DIP_FAMILY);
       GEN_TSU         : Time       := TSU (DIP_FAMILY);
       GEN_TH          : Time       := TH (DIP_FAMILY);
  
       TWD_CLK  : Time;
       TWD_J    : Time;
       TWD_K    : Time;
       TWD_PR   : Time;
       TWD_CLR  : Time;
  
       CL_Q     : Real;
       CL_QB    : Real;
  
       REF  : String := DIP_REF
  );
  
  port (
     Q        : out Std_Ulogic ;
     QB       : out Std_Ulogic ;

     CLK      : in Std_Ulogic ;
     J        : in Std_Ulogic ;
     K        : in Std_Ulogic ;
     PR       : in Std_Ulogic ;
     CLR      : in Std_Ulogic 
   );
  end component;

  for all : JKFF use entity SN54xx109.SN54xx109(BEHAVIORAL);

----------------------------------------------------------------------
begin

  PART1: JKFF 
  generic map (
     TWD_CLK    => TWD_CLK1,
     TWD_J      => TWD_J1,
     TWD_K      => TWD_K1,
     TWD_PR     => TWD_PR1,
     TWD_CLR    => TWD_CLR1,
     CL_Q       => CL_Q1,
     CL_QB      => CL_QB1
  )

  port map (
     Q     => Q1,
     QB    => QB1,
     CLK   => CLK1,
     J     => J1,
     K     => K1,
     PR    => PR1,
     CLR   => CLR1
     ) ;

----------------------------------------------------------------------
  PART2: JKFF 
  generic map
  (
     TWD_CLK    => TWD_CLK2,
     TWD_J      => TWD_J2,
     TWD_K      => TWD_K2,
     TWD_PR     => TWD_PR2,
     TWD_CLR    => TWD_CLR2,
     CL_Q       => CL_Q2,
     CL_QB      => CL_QB2
  )

  port map (
     Q     => Q2,
     QB    => QB2,
     CLK   => CLK2,
     J     => J2,
     K     => K2,
     PR    => PR2,
     CLR   => CLR2
     ) ;

----------------------------------------------------------------------

end STRUCTURAL;
