-- Filename : waves_device_SN54xx08.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library WAVES_STANDARD;
use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is ( TP_Y1, TP_Y2, TP_Y3, TP_Y4,TP_A1, TP_B1, 
                        TP_A2, TP_B2, TP_A3, TP_B3, TP_A4, TP_B4);

  constant DEVICE_ID : String := "SN54xx08";

  -- The following declaration is just for documentation purposes.
  constant PIN_DIRECTION : Direction_List := (Response,   -- TP_Y1
                                              Response,   -- TP_Y2
                                              Response,   -- TP_Y3
                                              Response,   -- TP_Y4
                                              Stimulus,   -- TP_A1
                                              Stimulus,   -- TP_B1
                                              Stimulus,   -- TP_A2
                                              Stimulus,   -- TP_B2
                                              Stimulus,   -- TP_A3
                                              Stimulus,   -- TP_B3
                                              Stimulus,   -- TP_A4
                                              Stimulus);   -- TP_B4)
      
  function PIN_NAME (PIN : Test_Pins) return String;
    
end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_Y1    => return "Y1";
      when TP_Y2    => return "Y2";
      when TP_Y3    => return "Y3";
      when TP_Y4    => return "Y4";
      when TP_A1    => return "A1";
      when TP_B1    => return "B1";
      when TP_A2    => return "A2";
      when TP_B2    => return "B2";
      when TP_A3    => return "A3";
      when TP_B3    => return "B3";
      when TP_A4    => return "A4";
      when TP_B4    => return "B4";
    end case;
  end;
end WAVES_DEVICE;

