-- Filename : waves_device_SN54xx04.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library WAVES_STANDARD;
use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is
  type Test_Pins is
  (
    TP_Y1, TP_Y2, TP_Y3, TP_Y4, TP_Y5, TP_Y6,
    TP_A1, TP_A2, TP_A3, TP_A4, TP_A5, TP_A6
  );

  constant DEVICE_ID : String := "SN54xx04";

  -- The following declaration is just for documentation purposes.
  constant PIN_DIRECTION : Direction_List :=(Response,   -- TP_Y1
                                             Response,   -- TP_Y2
                                             Response,   -- TP_Y3
                                             Response,   -- TP_Y4
                                             Response,   -- TP_Y5
                                             Response,   -- TP_Y6
                                             Stimulus,   -- TP_A1
                                             Stimulus,   -- TP_A2
                                             Stimulus,   -- TP_A3
                                             Stimulus,   -- TP_A4
                                             Stimulus,   -- TP_A5
                                             Stimulus);  -- TP_A6

        
  function PIN_NAME (PIN : Test_Pins) return String;

end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_Y1 => return "Y1";
      when TP_Y2 => return "Y2";
      when TP_Y3 => return "Y3";
      when TP_Y4 => return "Y4";
      when TP_Y5 => return "Y5";
      when TP_Y6 => return "Y6";
      when TP_A1 => return "A1";
      when TP_A2 => return "A2";
      when TP_A3 => return "A3";
      when TP_A4 => return "A4";
      when TP_A5 => return "A5";
      when TP_A6 => return "A6";
    end case;
  end;

end WAVES_DEVICE;




