-- Filename : SN54xx04_TB_CON.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library STD_PACK;
  use STD_PACK.SIMFLAG.all;    -- Global simulation options
  use STD_PACK.TTL_TIMING.all; -- TTL derating coefficients

library SN54xx04;
  use SN54xx04.SN54xx04_TIMING.all;  -- timing module

configuration SN54xx04_TB_CON of SN54xx04_TB is

for TEST_BENCH
  for UNDER_TEST : DUT use entity SN54xx04.SN54xx04_DIP14(STRUCTURAL)
    generic map (
      DIP_TIME_MODE => TYPICAL,      -- MIN, TYP, or MAX
      DIP_FAMILY    => STD_FAMILY,   -- STD, S, or LS
      DIP_VCC       => 5.0,   -- Volts
      DIP_TA        => 25.0,  -- degrees Celsius
      DIP_DFACTOR   => 100.0, -- percent
      DIP_REF => "SN54xx04",   -- component reference designator

      TWD_A1 => 0 ns,  -- back-annotated input wire delays
      TWD_A2 => 0 ns,
      TWD_A3 => 0 ns,
      TWD_A4 => 0 ns,
      TWD_A5 => 0 ns,
      TWD_A6 => 0 ns,

      CL_Y1 => 15.0,   -- back-annotated output loading (picofarads)
      CL_Y2 => 15.0,   -- (timing module will adjust time accordingly)
      CL_Y3 => 15.0,
      CL_Y4 => 15.0,
      CL_Y5 => 15.0,
      CL_Y6 => 15.0
    );

   end for;
end for;        

end SN54xx04_TB_CON;
