-- Filename : SN54xx04.vhd
--
-- Version 2.1
--
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--      
--
--        ------------------------------------------------------------------
--

library IEEE;                      -- Logic system
  use IEEE.STD_LOGIC_1164.all;     -- Global simulation options

library STD_PACK;                  -- Standard library for all models
  use STD_PACK.MISC_FUNC.all;      -- Timing functions
  use STD_PACK.TIME_FUNC.ALL;
  use STD_PACK.TTL_TIMING.all;     -- TTL derating coefficients

library SN54xx04;
  use SN54xx04.SN54xx04_TIMING.ALL;    -- SN54xx04 timing module

entity SN54xx04 is
  generic 
  (
   GEN_PROP_TIMES : Prop_Times;
   GEN_FAMILY : Tech_Type;

   TWD_A : Time;

   CL_Y  : Real;

   REF : String
  );

  port
  (
    Y     : out Std_Ulogic := 'U';
    A     : in Std_Ulogic := 'U'
  );

end SN54xx04;

-- ======================================================================

architecture BEHAVIORAL of SN54xx04 is

  constant MODEL_TIMES : Prop_Times := BACK_ANNOTATE(GEN_PROP_TIMES,GEN_FAMILY,CL_Y);

  -- Local signal declarations

  signal AIN  : UX01 := 'U';
  signal YOUT : UX01Z := 'U';

  begin

    -- assign pin value to internal signal after wire delay
    AIN <= transport CONVERT_TO_UX01(A) after TWD_A;

    -- Assign internal value to output pin
    Y <=  YOUT;


-------------------------------------------------------------------------

  INV : process (AIN)

    variable OUTPUT_VALUE : Std_Ulogic;

  begin
    
    YOUT <= transport OUTPUT_VALUE after TP_DELAY(OUTPUT_VALUE,
      MODEL_TIMES.TPLH, MODEL_TIMES.TPHL);
  end process INV;

-------------------------------------------------------------------------

end BEHAVIORAL;










