-- Filename : SN54xx02_TB_CON.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library STD_PACK;
  use STD_PACK.SIMFLAG.all;    -- Global simulation options
  use STD_PACK.TTL_TIMING.all; -- TTL derating coefficients

library SN54xx02;
  use SN54xx02.SN54xx02_TIMING.all;  -- timing module

configuration SN54xx02_TB_CON of SN54xx02_TB is

  for TEST_BENCH
    for UNDER_TEST : DUT use entity SN54xx02.SN54xx02_DIP14(STRUCTURAL)
    generic map (
      DIP_TIME_MODE => TYPICAL,      -- MIN, TYP, or MAX
      DIP_FAMILY    => STD_FAMILY,   -- STD, S, or LS
      DIP_VCC       => VCC,
      DIP_TA        => TA,
      DIP_DFACTOR   => DERATE_FACTOR,
      DIP_REF       => "SN54xx02",   -- component reference designator

      TWD_A1 => 0 ns,  -- back-annotated input wire delays
      TWD_B1 => 0 ns,
      TWD_A2 => 0 ns,
      TWD_B2 => 0 ns,
      TWD_A3 => 0 ns,
      TWD_B3 => 0 ns,
      TWD_A4 => 0 ns,
      TWD_B4 => 0 ns,

      CL_Y1 => 15.0,   -- back-annotated output loading (picofarads)
      CL_Y2 => 15.0,   -- (timing module will adjust time accordingly)
      CL_Y3 => 15.0,
      CL_Y4 => 15.0
    );

      for STRUCTURAL
        for ALL : NORGATE use entity SN54xx02.SN54xx02(BEHAVIORAL);
         end for;
      end for;
    end for;
  end for;        

end SN54xx02_TB_CON;
