-- FILE NAME:        waves_device_full_adder.vhd
--
--                                   DISCLAIMER
--
--        This code is the sole property of the Institute for Technology
--        Development (ITD), Jackson, Mississippi, and is distributed for
--        the purpose of providing examples of VHDL models written to
--        modeling standards.  This code may not be used for commercial
--        purposes, and may not be redistributed without permission from
--        the Institute for Technology Development.  ITD assumes no 
--        responsibility for errors, omissions, uses made, or decisions
--        based on its use.  No warranties, expressed or implied, are given.
--
--        This is a modified IEEE WAVES package.  It was written specifically
--        to describe the test pins of the model being tested.
--
--        ------------------------------------------------------------------

library WAVES_STANDARD ;
  use WAVES_STANDARD.WAVES_STANDARD.all ;

package WAVES_DEVICE is

    type Test_Pins is ( TP_A, TP_B, TP_CIN, 
                        TP_SUM, TP_COUT) ;

    constant DEVICE_ID : string := "full_adder" ;

  -- The following declaration is just for documentation purposes.

    constant PIN_DIRECTION : Direction_List := (Stimulus,   -- TP_A
                                                Stimulus,   -- TP_B
                                                Stimulus,   -- TP_CIN
                                                Response,   -- TP_SUM
                                                Response);  -- TP_COUT
        
    function PIN_NAME (PIN : Test_Pins) return string ;

end WAVES_DEVICE ;


-- ======================================================================

package body WAVES_DEVICE is

    function PIN_NAME (PIN : Test_Pins) return string is
    begin
        case PIN is
            when TP_Cin => return "Cin" ;
            when TP_A => return "A" ;
            when TP_B => return "B" ;
            when TP_Sum => return "Sum" ;
            when TP_Cout => return "Cout" ;
        end case ;
    end ;

end WAVES_DEVICE ;

