--  FILENAME: full_adder_con.vhd
--
--                                   DISCLAIMER
--
--        This code is the sole property of the Institute for Technology
--        Development (ITD), Jackson, Mississippi, and is distributed for
--        the purpose of providing examples of VHDL models written to
--        modeling standards.  This code may not be used for commercial
--        purposes, and may not be redistributed without permission from
--        the Institute for Technology Development.  ITD assumes no 
--        responsibility for errors, omissions, uses made, or decisions
--        based on its use.  No warranties, expressed or implied, are given.
--
--        ------------------------------------------------------------------


-- This is the configuration file for the full adder.  Selected generics
-- are assigned below as an example of using the generic map.  Generics
-- not assigned below are assigned their default values at elaboration.
-- Observe the effect of various generic parameters on the model's timing.

library SN54xx86;
library SN54xx00;
library STD_PACK;
  use STD_PACK.SIMFLAG.all;
  use STD_PACK.TTL_TIMING.all;

configuration FULL_ADDER_CON of FULL_ADDER is

  for STRUCTURAL

    for NAND1 : NAND_CHIP use entity SN54xx00.SN54xx00_DIP14(STRUCTURAL)
      generic map (
        DIP_TIME_MODE => MINIMUM,
        DIP_FAMILY    => LS_FAMILY,
        TWD_A3 => 1 ns,  -- wire delays
        TWD_B3 => 1 ns,
        TWD_A4 => 2 ns,
        TWD_B4 => 2 ns
      );
    end for;

    for NOR1 : NOR_CHIP	use entity SN54xx86.SN54xx86_DIP14(STRUCTURAL)
      generic map (
        DIP_TIME_MODE => TYPICAL,
        DIP_FAMILY    => S_FAMILY,
        CL_Y1 => 30.0   -- fanout of 2
      );

    end for;

  end for;

end FULL_ADDER_CON;
