--  File name:        full_adder_TB.vhd
--
--                                   DISCLAIMER
--
--        This code is the sole property of the Institute for Technology
--        Development (ITD), Jackson, Mississippi, and is distributed for
--        the purpose of providing examples of VHDL models written to
--        modeling standards.  This code may not be used for commercial
--        purposes, and may not be redistributed without permission from
--        the Institute for Technology Development.  ITD assumes no 
--        responsibility for errors, omissions, uses made, or decisions
--        based on its use.  No warranties, expressed or implied, are given.
--
--        ------------------------------------------------------------------

library IEEE;
  use IEEE.STD_LOGIC_1164.all;       -- Defines logic types, operators, functions


library WAVES_STANDARD ;
  use WAVES_STANDARD.WAVES_INTERFACE.all ;

library FULL_ADDER;
  use FULL_ADDER.WAVES_DEVICE.all ;
  use FULL_ADDER.WAVES_OBJECTS.all ;
  use FULL_ADDER.WAVES_UTILITIES.all ;
  use FULL_ADDER.WGENERATOR_full_adder.all ;

entity FULL_ADDER_TB is
  begin
  end FULL_ADDER_TB ;

-- ======================================================================

architecture TEST_BENCH of FULL_ADDER_TB is

    component DUT 
      port (
        A,B,CIN : in Std_Ulogic;
        SUM,COUT : out Std_Ulogic
      );
    end component ;

    for all : DUT use configuration FULL_ADDER.FULL_ADDER_CON;

    subtype Test_Pin_Range is integer range
        Test_Pins'pos(TP_A) + 1 to Test_Pins'pos(TP_COUT) + 1;

  -- Input and Output traffic of DUT
    signal TRAFFIC : Std_Ulogic_Vector(Test_Pin_Range) ;

  -- Test program options
    constant IN_FILE_NAME : string := "full_adder_in.dat" ;
    constant START_TOLERANCE : time := 2 ns ;
    constant END_TOLERANCE : time := 2 ns ;
    constant DEFAULT_PERIOD : time := 100 ns ;
    constant DEFAULT_UNCERTAINTY : real := 0.95 ;

  -- Comparator options
    signal COMPARE : boolean := true ;
    constant HOW_TO_REPORT : Comparison_Format := DO_ASSERTION ;
    constant ASSERTION_LEVEL : Severity_Level := WARNING ;

  -- Signal monitor options
    constant HOW_TO_PRINT : Output_Format := Standard ;
    constant OUT_FILE_NAME : string := "full_adder_out.dat" ;

--    signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) := (others.M_VALUE => TRUE) ;
    signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) ;

  -- Connection to WAVES dataset
    signal CONNECT : Waves_Port_List (Test_Pin_Range) ;

    subtype Compare_Pin_Range is integer range
        Test_Pins'pos(TP_SUM) + 1 to Test_Pins'pos(TP_COUT) + 1;

------------------------------------------------------------------------------

begin

    -- Call the waveform generator (i.e., the WAVES dataset)
    process begin

--    full_adder_TEST(CONNECT, IN_FILE_NAME, START_TOLERANCE, END_TOLERANCE) ;

--  uncomment the following procedure to use vectors declared in the wgenerator file.
--      full_adder_TEST(CONNECT) ;

--  uncomment the following procedure to read vectors from a file
      full_adder_TEST(CONNECT, IN_FILE_NAME, DEFAULT_PERIOD, DEFAULT_UNCERTAINTY) ;

      wait ;
    end process ;

  ----------------------------------------------------------------------------
    -- Instantiate the Device under test

    UNDER_TEST : DUT
    port map (
        TRAFFIC(Test_Pins'Pos(TP_A) + 1),
        TRAFFIC(Test_Pins'Pos(TP_B) + 1),
        TRAFFIC(Test_Pins'Pos(TP_Cin) + 1),
        TRAFFIC(Test_Pins'Pos(TP_Sum) + 1),
        TRAFFIC(Test_Pins'Pos(TP_Cout) + 1)
    );

  ----------------------------------------------------------------------------
    -- Collect all signals (inputs and output of DUT) into signal TRAFFIC

    COLLECT_INPUTS:
    for I in Test_Pins'pos(TP_A) + 1 to Test_Pins'pos(TP_CIN) + 1 generate
                TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
                        (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I))) ;
    end generate COLLECT_INPUTS ;

  ----------------------------------------------------------------------------

    SIGNAL_TRAFFIC : SIGNAL_MONITOR(OUT_FILE_NAME, TRAFFIC, HOW_TO_PRINT) ;

  ----------------------------------------------------------------------------

    GEN_COMPARATOR:
    for I in Compare_Pin_Range generate
      COMPARATOR : CHECK_RESPONSE(
        WHICH_ONE => I,
        RESPONSE => TRAFFIC(I),
        PREDICTION => CONNECT(I),
        COMPARE => COMPARE,
        HOW_TO_REPORT => HOW_TO_REPORT,
        ASSERTION_LEVEL => ASSERTION_LEVEL,
        MATCH => SMATCH(I).M_VALUE ) ;

    end generate GEN_COMPARATOR ;

end TEST_BENCH ;

