--        Filename : full_adder.vhd
--
--                                   DISCLAIMER
--
--        This code is the sole property of the Institute for Technology
--        Development (ITD), Jackson, Mississippi, and is distributed for
--        the purpose of providing examples of VHDL models written to
--        modeling standards.  This code may not be used for commercial
--        purposes, and may not be redistributed without permission from
--        the Institute for Technology Development.  ITD assumes no
--        responsibility for errors, omissions, uses made, or decisions
--        based on its use.  No warranties, expressed or implied, are given.
--
--        ------------------------------------------------------------------

library IEEE;
  use IEEE.STD_LOGIC_1164.all;       -- Defines logic types, operators, functions

entity FULL_ADDER is
  port( 
    A, B, CIN : in Std_Ulogic;
    SUM, COUT : out Std_Ulogic
  );
begin
end FULL_ADDER;

-- ======================================================================

architecture STRUCTURAL of FULL_ADDER is

  signal SIG1, SIG2, SIG3 : Std_Ulogic;

  component NOR_CHIP
    port(
      Y1,Y2,Y3,Y4 : out Std_Ulogic := 'U';

      A1,B1,A2,B2,A3,B3,A4,B4 : in Std_Ulogic := 'U'
    );
  end component;

  component NAND_CHIP
    port(
      Y1,Y2,Y3,Y4 : out Std_Ulogic := 'U';
      A1,B1,A2,B2,A3,B3,A4,B4 : in Std_Ulogic := 'U');
   end component;

begin

  NAND1 : NAND_CHIP
    port map (
      A1 => A, 
      B1 => B, 
      Y1 => SIG3,

      A2 => SIG1,
      B2 => CIN,
      Y2 => SIG2,

      A3 => SIG2,
      B3 => SIG3,
      Y3 => COUT,

      A4 => open,
      B4 => open,
      Y4 => open
    );

  NOR1 : NOR_CHIP
    port map(
      A1 => A,
      B1 => B,
      Y1 => SIG1,

      A2 => SIG1,
      B2 => CIN,
      Y2 => SUM,

      A3 => open,
      B3 => open,
      Y3 => open,

      A4 => open,
      B4 => open,
      Y4 => open
    );

end STRUCTURAL;







