--  Filename : ymux_TB.vhd
--
-- Version 2.1
-----------------------------------------------------------------------------
--
library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library AM29C01_PACKAGE;
  use AM29C01_PACKAGE.TYPES.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library YMUX;
  use YMUX.WAVES_DEVICE.all;
  use YMUX.WAVES_OBJECTS.all;
  use YMUX.WAVES_UTILITIES.all;
  use YMUX.WGENERATOR_ymux.all;

entity ymux_TB is
  begin
  end ymux_TB;

-- ======================================================================

architecture TEST_BENCH of ymux_TB is

  component DUT 
    port 
    (
      IN1  : in  Fourbit;
      IN2  : in  Fourbit;
      SEL  : in  Std_Ulogic;
      O    : out Fourbit
    );
  end component;

  for all : DUT use entity YMUX.YMUX (BEHAVIORAL);

  subtype Test_Pin_Range is Integer range
      Test_Pins'pos(TP_IN1_3) + 1 to Test_Pins'pos(TP_O0) + 1;

  -- Input and Output traffic of DUT
  signal TRAFFIC : Std_Ulogic_Vector(Test_Pin_Range);

  signal IN1 : Fourbit;
  signal IN2 : Fourbit;
  signal o   : Fourbit;

  -- Test program options
  constant IN_FILE_NAME    : String := "ymux_waves.dat";
  constant START_TOLERANCE : Time := 2 ns;
  constant END_TOLERANCE   : Time := 2 ns;

  -- Comparator options
  signal COMPARE           : Boolean           := TRUE;
  constant HOW_TO_REPORT   : Comparison_Format := DO_ASSERTION;
  constant ASSERTION_LEVEL : Severity_Level    := WARNING;

  -- Signal monitor options
  constant HOW_TO_PRINT  : Output_Format := WAVES;
  constant OUT_FILE_NAME : String        := "ymux_out.dat";

  -- signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) :=
  -- (others.M_VALUE => TRUE);
  signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range);

  -- Connection to WAVES DATAset
  signal CONNECT : Waves_Port_List (Test_Pin_Range);

  subtype Compare_Pin_Range is Integer range
      Test_Pins'pos(TP_O3) + 1 to Test_Pins'pos(TP_O0) + 1;

------------------------------------------------------------------------------

begin

  -- Call the waveform generator (i.e., the WAVES DATAset)
  process
  begin
    -- ymux_TEST(CONNECT, IN_FILE_NAME, START_TOLERANCE, END_TOLERANCE);
    ymux_TEST(CONNECT);
    wait;
  end process;

----------------------------------------------------------------------------
  -- Instantiate the Device under test
  IN1(3) <= TRAFFIC(Test_Pins'Pos(TP_IN1_3) + 1);
  IN1(2) <= TRAFFIC(Test_Pins'Pos(TP_IN1_2) + 1);
  IN1(1) <= TRAFFIC(Test_Pins'Pos(TP_IN1_1) + 1);
  IN1(0) <= TRAFFIC(Test_Pins'Pos(TP_IN1_0) + 1);

  IN2(3) <= TRAFFIC(Test_Pins'Pos(TP_IN2_3) + 1);
  IN2(2) <= TRAFFIC(Test_Pins'Pos(TP_IN2_2) + 1);
  IN2(1) <= TRAFFIC(Test_Pins'Pos(TP_IN2_1) + 1);
  IN2(0) <= TRAFFIC(Test_Pins'Pos(TP_IN2_0) + 1);

  TRAFFIC(Test_Pins'Pos(TP_O3) + 1) <= o(3);
  TRAFFIC(Test_Pins'Pos(TP_O2) + 1) <= o(2);
  TRAFFIC(Test_Pins'Pos(TP_O1) + 1) <= o(1);
  TRAFFIC(Test_Pins'Pos(TP_O0) + 1) <= o(0);

  UNDER_TEST : DUT
    port map 
    (
      IN1,
      IN2,
      TRAFFIC(Test_Pins'Pos(TP_SEL) + 1),
      O
    );

----------------------------------------------------------------------------
  -- Collect all signals (inputs and output of DUT) into signal TRAFFIC

  COLLECT_INPUTS:
    for I in Test_Pins'pos(TP_IN1_3) + 1 to Test_Pins'pos(TP_SEL) + 1 generate
        TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
        (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I)));
  end generate COLLECT_INPUTS;

----------------------------------------------------------------------------

  SIGNAL_TRAFFIC : SIGNAL_MONITOR(OUT_FILE_NAME, TRAFFIC, HOW_TO_PRINT);
    
---------------------------------------------------------------------------

  GEN_COMPARATOR:
    for I in Compare_Pin_Range generate
      COMPARATOR : CHECK_RESPONSE(WHICH_ONE => I,
                                  RESPONSE => TRAFFIC(I),
                                  PREDICTION => CONNECT(I),
                                  COMPARE => COMPARE,
                                  HOW_TO_REPORT => HOW_TO_REPORT,
                                  ASSERTION_LEVEL => ASSERTION_LEVEL,
                                  MATCH => SMATCH(I).M_VALUE );

  end generate GEN_COMPARATOR;

end TEST_BENCH;

