-- Filename : waves_device_ts_buffer.vhd
--
-- Version 2.1
-----------------------------------------------------------------------------
--
--        This is a modified IEEE WAVES package.  It was written specifically
--        to describe the test pins of the model being tested.
--
--        ------------------------------------------------------------------

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is ( TP_DATA3, TP_DATA2, TP_DATA1, TP_DATA0, TP_ENABLE,
                      TP_O3, TP_O2, TP_O1, TP_O0);

  constant DEVICE_ID : String := "ts_buffer";

  -- The following declaration is just for documentation purposes.
  constant PIN_DIRECTION : Direction_List := (Stimulus,   -- TP_DATA3
                                              Stimulus,   -- TP_DATA2
                                              Stimulus,   -- TP_DATA1
                                              Stimulus,   -- TP_DATA0
                                              Stimulus,   -- TP_ENABLE
                                              Response,   -- TP_O3
                                              Response,   -- TP_O2
                                              Response,   -- TP_O1
                                              Response);  -- TP_O0

  function PIN_NAME (PIN : Test_Pins) return String;
    
end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_DATA3  => return "DATA3";
      when TP_DATA2  => return "DATA2";
      when TP_DATA1  => return "DATA1";
      when TP_DATA0  => return "DATA0";
      when TP_ENABLE => return "ENABLE";
      when TP_O3     => return "O3";
      when TP_O2     => return "O2";
      when TP_O1     => return "O1";
      when TP_O0     => return "O0";
    end case;
  end;

end WAVES_DEVICE;

