--  Filename : ts_buffer_TB.vhd
--
-- Version 2.1
-----------------------------------------------------------------------------
--
library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library AM29C01_PACKAGE;
  use AM29C01_PACKAGE.TYPES.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library TS_BUFFER;
  use TS_BUFFER.WAVES_DEVICE.all;
  use TS_BUFFER.WAVES_OBJECTS.all;
  use TS_BUFFER.WAVES_UTILITIES.all;
  use TS_BUFFER.WGENERATOR_TS_BUFFER.all;

entity ts_buffer_TB is
  begin
  end ts_buffer_TB;

-- ======================================================================

architecture TEST_BENCH of ts_buffer_TB is

  component DUT 
    port 
    (
      DATA   : in  Fourbit;
      ENABLE : in  Std_Ulogic;
      o      : out Fourbit
    );
  end component;

  for all : DUT use entity TS_BUFFER.TS_BUFFER (BEHAVIORAL);

  subtype Test_Pin_Range is Integer range
      Test_Pins'pos(TP_DATA3) + 1 to Test_Pins'pos(TP_o0) + 1;

  -- Input and Output traffic of DUT
  signal TRAFFIC : Std_Ulogic_Vector(Test_Pin_Range);

  signal DATA : Fourbit;
  signal O    : Fourbit;

  -- Test program options
  constant IN_FILE_NAME    : String := "ts_buffer_waves.dat";
  constant START_TOLERANCE : Time   := 2 ns;
  constant END_TOLERANCE   : Time   := 2 ns;

  -- Comparator options
  signal COMPARE           : Boolean           := TRUE;
  constant HOW_TO_REPORT   : Comparison_Format := DO_ASSERTION;
  constant ASSERTION_LEVEL : Severity_Level    := WARNING;

  -- Signal monitor options
  constant HOW_TO_PRINT  : Output_Format := WAVES;
  constant OUT_FILE_NAME : String := "ts_buffer_out.dat";

--    signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) := (others.M_VALUE => TRUE);
  signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range);

  -- Connection to WAVES DATAset
  signal CONNECT : Waves_Port_List (Test_Pin_Range);

  subtype Compare_Pin_Range is Integer range
      Test_Pins'pos(TP_O3) + 1 to Test_Pins'pos(TP_O0) + 1;

------------------------------------------------------------------------------

begin

  -- Call the waveform generator (i.e., the WAVES DATAset)
  process 
  begin
    -- ts_buffer_TEST(CONNECT, IN_FILE_NAME, START_TOLERANCE, END_TOLERANCE);
    ts_buffer_TEST(CONNECT);
    wait;
  end process;

----------------------------------------------------------------------------
  -- Instantiate the Device under test

  DATA(3) <= TRAFFIC(Test_Pins'Pos(TP_DATA3) + 1);
  DATA(2) <= TRAFFIC(Test_Pins'Pos(TP_DATA2) + 1);
  DATA(1) <= TRAFFIC(Test_Pins'Pos(TP_DATA1) + 1);
  DATA(0) <= TRAFFIC(Test_Pins'Pos(TP_DATA0) + 1);

  TRAFFIC(Test_Pins'Pos(TP_O3) + 1) <= O(3);
  TRAFFIC(Test_Pins'Pos(TP_O2) + 1) <= O(2);
  TRAFFIC(Test_Pins'Pos(TP_O1) + 1) <= O(1);
  TRAFFIC(Test_Pins'Pos(TP_O0) + 1) <= O(0);

  UNDER_TEST : DUT
    port map 
    (
      DATA,
      TRAFFIC(Test_Pins'Pos(TP_ENABLE) + 1),
      O
    );

----------------------------------------------------------------------------
  -- Collect all signals (inputs and output of DUT) into signal TRAFFIC

  COLLECT_INPUTS:
  for I in Test_Pins'pos(TP_DATA3) + 1 to Test_Pins'pos(TP_ENABLE) + 1 generate
      TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
      (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I)));
  end generate COLLECT_INPUTS;

----------------------------------------------------------------------------

  SIGNAL_TRAFFIC : SIGNAL_MONITOR(OUT_FILE_NAME, TRAFFIC, HOW_TO_PRINT);

----------------------------------------------------------------------------

  GEN_COMPARATOR:
    for I in Compare_Pin_Range generate
      COMPARATOR : CHECK_RESPONSE(WHICH_ONE => I,
                                  RESPONSE => TRAFFIC(I),
                                  PREDICTION => CONNECT(I),
                                  COMPARE => COMPARE,
                                  HOW_TO_REPORT => HOW_TO_REPORT,
                                  ASSERTION_LEVEL => ASSERTION_LEVEL,
                                  MATCH => SMATCH(I).M_VALUE );

  end generate GEN_COMPARATOR;

end TEST_BENCH;

