--  Filename : smux_TB.vhd
--
-- Version 2.1
-----------------------------------------------------------------------------
--
library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library AM29C01_PACKAGE;
  use AM29C01_PACKAGE.TYPES.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library SMUX;
  use SMUX.WAVES_DEVICE.all;
  use SMUX.WAVES_OBJECTS.all;
  use SMUX.WAVES_UTILITIES.all;
  use SMUX.WGENERATOR_SMUX.all;

entity smux_TB is
  begin
  end smux_TB;

-- ======================================================================

architecture TEST_BENCH of smux_TB is

  component DUT 
    port 
    (
      IN1  : in  Fourbit;
      IN2  : in  Fourbit;
      IN3  : in  Fourbit;
      SEL  : in  Twobit;
      O    : out Fourbit
    );
  end component;

  for all : DUT use entity SMUX.SMUX (BEHAVIORAL);

  subtype Test_Pin_Range is Integer range
      Test_Pins'pos(TP_IN1_3) + 1 to Test_Pins'pos(TP_O0) + 1;

  -- Input and Output traffic of DUT
  signal TRAFFIC : Std_Ulogic_Vector(Test_Pin_Range);

  signal IN1 : Fourbit;
  signal IN2 : Fourbit;
  signal IN3 : Fourbit;
  signal SEL : Twobit;
  signal O   : Fourbit;

  -- Test program options
  constant IN_FILE_NAME        : String := "smux_in.dat";
  constant START_TOLERANCE     : Time := 2 ns;
  constant END_TOLERANCE       : Time := 2 ns;
  constant DEFAULT_PERIOD      : Time := 5 ns;
  constant DEFAULT_UNCERTAINTY : Real := 0.95;

  -- Comparator options
  signal COMPARE           : Boolean           := TRUE;
  constant HOW_TO_REPORT   : Comparison_Format := DO_ASSERTION;
  constant ASSERTION_LEVEL : Severity_Level    := WARNING;

  -- Signal monitor options
  constant HOW_TO_PRINT  : Output_Format := STANDARD;
  constant OUT_FILE_NAME : String        := "smux_out.dat";

  -- signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) :=
  -- (others.M_VALUE => TRUE);
  signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range);

  -- Connection to WAVES dataset
  signal CONNECT : Waves_Port_List (Test_Pin_Range);

  subtype Compare_Pin_Range is Integer range
      Test_Pins'pos(TP_O3) + 1 to Test_Pins'pos(TP_O0) + 1;

------------------------------------------------------------------------------

begin

  -- Call the waveform generator (i.e., the WAVES dataset)
  process
  begin
    -- SMUX_TEST(CONNECT);
    SMUX_TEST(CONNECT, IN_FILE_NAME, DEFAULT_PERIOD, DEFAULT_UNCERTAINTY);
    -- SMUX_TEST(CONNECT, IN_FILE_NAME, START_TOLERANCE, END_TOLERANCE);
    wait;
  end process;

----------------------------------------------------------------------------
  -- Instantiate the Device under test

  IN1(3) <= TRAFFIC(Test_Pins'Pos(TP_IN1_3) + 1);
  IN1(2) <= TRAFFIC(Test_Pins'Pos(TP_IN1_2) + 1);
  IN1(1) <= TRAFFIC(Test_Pins'Pos(TP_IN1_1) + 1);
  IN1(0) <= TRAFFIC(Test_Pins'Pos(TP_IN1_0) + 1);

  IN2(3) <= TRAFFIC(Test_Pins'Pos(TP_IN2_3) + 1);
  IN2(2) <= TRAFFIC(Test_Pins'Pos(TP_IN2_2) + 1);
  IN2(1) <= TRAFFIC(Test_Pins'Pos(TP_IN2_1) + 1);
  IN2(0) <= TRAFFIC(Test_Pins'Pos(TP_IN2_0) + 1);

  IN3(3) <= TRAFFIC(Test_Pins'Pos(TP_IN3_3) + 1);
  IN3(2) <= TRAFFIC(Test_Pins'Pos(TP_IN3_2) + 1);
  IN3(1) <= TRAFFIC(Test_Pins'Pos(TP_IN3_1) + 1);
  IN3(0) <= TRAFFIC(Test_Pins'Pos(TP_IN3_0) + 1);

  SEL(1) <= TRAFFIC(Test_Pins'Pos(TP_SEL1) + 1);
  SEL(0) <= TRAFFIC(Test_Pins'Pos(TP_SEL0) + 1);

  TRAFFIC(Test_Pins'Pos(TP_o3) + 1) <= o(3);
  TRAFFIC(Test_Pins'Pos(TP_o2) + 1) <= o(2);
  TRAFFIC(Test_Pins'Pos(TP_o1) + 1) <= o(1);
  TRAFFIC(Test_Pins'Pos(TP_o0) + 1) <= o(0);

  UNDER_TEST : DUT
    port map 
    (
      IN1,
      IN2, 
      IN3,
      SEL,
      O
    );

----------------------------------------------------------------------------
  -- Collect all signals (inputs and output of DUT) into signal TRAFFIC
  COLLECT_INPUTS:
    for I in Test_Pins'pos(TP_IN1_3) + 1 to Test_Pins'pos(TP_SEL0) + 1 generate
        TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
        (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I)));
  end generate COLLECT_INPUTS;

----------------------------------------------------------------------------

  SIGNAL_TRAFFIC : SIGNAL_MONITOR(OUT_FILE_NAME, TRAFFIC, HOW_TO_PRINT);

----------------------------------------------------------------------------

  GEN_COMPARATOR:
    for I in Compare_Pin_Range generate
      COMPARATOR : CHECK_RESPONSE(WHICH_ONE => I,
                                  RESPONSE => TRAFFIC(I),
                                  PREDICTION => CONNECT(I),
                                  COMPARE => COMPARE,
                                  HOW_TO_REPORT => HOW_TO_REPORT,
                                  ASSERTION_LEVEL => ASSERTION_LEVEL,
                                  MATCH => SMATCH(I).M_VALUE );

  end generate GEN_COMPARATOR;

end TEST_BENCH;

