-- Filename : waves_device_shifter.vhd
--
-- Version 2.1
-----------------------------------------------------------------------------
--
--        This is a modified IEEE WAVES package.  It was written specifically
--        to describe the test pins of the model being tested.
--
--        ------------------------------------------------------------------
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is ( TP_DATA3, TP_DATA2, TP_DATA1, TP_DATA0,
                      TP_Y3, TP_Y2, TP_Y1, TP_Y0,
                      TP_SHIFTSEL, TP_DIRECTION, TP_SINLSB, TP_SINMSB,
                      TP_SOUTLSB, TP_SOUTMSB);

  constant DEVICE_ID : String := "shifter";

  -- The following declaration is just for documentation purposes.

  constant PIN_DIRECTION : Direction_List := (Stimulus,   -- TP_DATA3
                                              Stimulus,   -- TP_DATA2
                                              Stimulus,   -- TP_DATA1
                                              Stimulus,   -- TP_DATA0
                                              Response,   -- TP_Y3
                                              Response,   -- TP_Y2
                                              Response,   -- TP_Y1
                                              Response,   -- TP_Y0
                                              Stimulus,   -- TP_SHIFTSEL
                                              Stimulus,   -- TP_DIRECTION
                                              Stimulus,   -- TP_SINLSB
                                              Stimulus,   -- TP_SINMSB
                                              Response,   -- TP_SOUTLSB
                                              Response);  -- TP_SOUTMSB
      

  function PIN_NAME (PIN : Test_Pins) return String;
   
end WAVES_DEVICE;
-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_DATA3     => return "DATA3";
      when TP_DATA2     => return "DATA2";
      when TP_DATA1     => return "DATA1";
      when TP_DATA0     => return "DATA0";
      when TP_Y3        => return "Y3";
      when TP_Y2        => return "Y2";
      when TP_Y1        => return "Y1";
      when TP_Y0        => return "Y0";
      when TP_SHIFTSEL  => return "SHIFTSEL";
      when TP_DIRECTION => return "DIRECTION";
      when TP_SINLSB    => return "SINLSB";
      when TP_SINMSB    => return "SINMSB";
      when TP_SOUTLSB   => return "SOUTLSB";
      when TP_SOUTMSB   => return "SOUTMSB";
    end case;
  end;

end WAVES_DEVICE;

