-- Filename : shifter.vhd
--
-- Version 2.1
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--
-----------------------------------------------------------------------------
-- DESCRIPTION:             
--
-- This file contains the entity declaration and behavioral model for a logical 
-- shifter. Direction of data shift is determined by a control line. This module
-- is intended for use as the ramshift and q shift blocks of the Am2901.

library IEEE;                            -- Logic system
  use IEEE.STD_LOGIC_1164.all;           -- Defines logic types,
                                         -- operators, functions

library Am29C01_PACKAGE;
  use Am29C01_PACKAGE.TYPES.all;

entity SHIFTER is
  port
  (
    DATA      : in  Fourbit;             -- data into shifter
    Y         : out Fourbit;             -- data out of shifter 
    SHIFTSEL  : in  Std_Ulogic;          -- select to shift or not, 1 = shift
    DIRECTION : in  Std_Ulogic;          -- which direction, 0=right(down)
    SINLSB    : in  Std_Ulogic := 'U';   -- shift in from right (lsb) 
    SINMSB    : in  Std_Ulogic := 'U';   -- shift in from left (msb) 
    SOUTLSB   : out Std_Ulogic := 'U';   -- shift our right (lsb)
    SOUTMSB   : out Std_Ulogic := 'U');  -- shift our left (msb)
end SHIFTER;

-- ======================================================================

-- the most significant bit is the first element of the data array

architecture BEHAVIORAL of SHIFTER is

begin
  SHIFT : process 
  begin
    wait on DATA, SHIFTSEL, DIRECTION, SINLSB, SINMSB;
    if (DIRECTION = '1') then
      SOUTLSB <= 'Z';
      wait for 0 ns;
    elsif (DIRECTION = '0') then
      SOUTMSB <= 'Z';
      wait for 0 ns;
    end if;           
        
    case SHIFTSEL is
      when '1' =>  -- shift
        if DIRECTION = '1' then -- shift left(up)
          SOUTMSB <= DATA(3);
          Y(3)    <= DATA(2);
          Y(2)    <= DATA(1);
          Y(1)    <= DATA(0);
          Y(0)    <= SINLSB;
        elsif DIRECTION = '0' then -- shift right(down)
          Y(3)    <= SINMSB;
          Y(2)    <= DATA(3);
          Y(1)    <= DATA(2);
          Y(0)    <= DATA(1);
          SOUTLSB <= DATA(0);
        else -- don't know if shifting left,right
          Y       <= "XXXX";
          SOUTMSB <= 'Z';
          SOUTLSB <= 'Z';
        end if;

      when '0' => -- don't shift
        Y         <= DATA;
        SOUTMSB   <= 'Z';
        SOUTLSB   <= 'Z';

      when others => 
        Y         <= "XXXX";
        SOUTMSB   <= 'Z';
        SOUTLSB   <= 'Z';

    end case; -- SHIFTSEL

  end process SHIFT;

end BEHAVIORAL;
