-- Filename : waves_device_rmux.vhd
--
-- Version 2.1
-----------------------------------------------------------------------------
--
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is ( TP_IN1_3, TP_IN1_2, TP_IN1_1, TP_IN1_0,
                      TP_IN2_3, TP_IN2_2, TP_IN2_1, TP_IN2_0,
                      TP_SEL1, TP_SEL0, TP_O3, TP_O2, TP_O1, TP_O0);

  constant DEVICE_ID : String := "rmux";

  -- The following declaration is just for documentation purposes.
  constant PIN_DIRECTION : Direction_List := (Stimulus,   -- TP_IN1_3
                                              Stimulus,   -- TP_IN1_2
                                              Stimulus,   -- TP_IN1_1
                                              Stimulus,   -- TP_IN1_0
                                              Stimulus,   -- TP_IN2_3
                                              Stimulus,   -- TP_IN2_2
                                              Stimulus,   -- TP_IN2_1
                                              Stimulus,   -- TP_IN2_0
                                              Stimulus,   -- TP_SEL1
                                              Stimulus,   -- TP_SEL0
                                              Response,   -- TP_O3
                                              Response,   -- TP_O2
                                              Response,   -- TP_O1
                                              Response);  -- TP_O0

  function PIN_NAME (PIN : Test_Pins) return String;
        
end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_IN1_3 => return "IN1_3";
      when TP_IN1_2 => return "IN1_2";
      when TP_IN1_1 => return "IN1_1";
      when TP_IN1_0 => return "IN1_0";
      when TP_IN2_3 => return "IN2_3";
      when TP_IN2_2 => return "IN2_2";
      when TP_IN2_1 => return "IN2_1";
      when TP_IN2_0 => return "IN2_0";
      when TP_SEL1  => return "SEL1";
      when TP_SEL0  => return "SEL0";
      when TP_O3    => return "O3";
      when TP_O2    => return "O2";
      when TP_O1    => return "O1";
      when TP_O0    => return "O0";
    end case;
  end;

end WAVES_DEVICE;

