-- FILE NAME:              rmux.vhd
--
-- Version 2.1
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--
-----------------------------------------------------------------------------
-- DESCRIPTION:             
--
-- This file contains the entity declaration and behavioral model for
-- a 4-bit 2 to 1 mux with a ZERO data channel.

library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library AM29C01_PACKAGE;
  use AM29C01_PACKAGE.TYPES.all;
  use AM29C01_PACKAGE.FUNCTIONS.all;
 
entity RMUX is
  port
  (
    IN1  : in Fourbit;
    IN2  : in Fourbit;
    SEL  : in Twobit;
    O    : out Fourbit
  );
end RMUX;

-- ======================================================================

architecture BEHAVIORAL of RMUX is

begin
  process(IN1, IN2, SEL)
    begin
      case SEL is
        when "00" => O <= IN1;
        when "01" => O <= IN2;
        when "10" => O <= "0000";
        when others => 
          if (unINit_on_bus(SEL)) then
            O <= "UUUU";
          else
            O <= "XXXX";
          end if;    
      end case;
    end process;

end BEHAVIORAL;
