-- Filename : waves_device_ram.vhd
--
-- Version 2.1
-----------------------------------------------------------------------------
--
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is ( TP_A3, TP_A2, TP_A1, TP_A0,
                      TP_B3, TP_B2, TP_B1, TP_B0,
                      TP_AOUT3, TP_AOUT2, TP_AOUT1, TP_AOUT0,
                      TP_BOUT3, TP_BOUT2, TP_BOUT1, TP_BOUT0,
                      TP_DATA_IN3, TP_DATA_IN2, TP_DATA_IN1, TP_DATA_IN0,
                      TP_RAM_EN, TP_CP);

  constant DEVICE_ID : String := "ram";

  -- The following declaration is just for documentation purposes.
  constant PIN_DIRECTION : Direction_List := (Stimulus,   -- TP_A3
                                              Stimulus,   -- TP_A2
                                              Stimulus,   -- TP_A1
                                              Stimulus,   -- TP_A0
                                              Stimulus,   -- TP_B3
                                              Stimulus,   -- TP_B2
                                              Stimulus,   -- TP_B1
                                              Stimulus,   -- TP_B0
                                              Response,   -- TP_AOUT3
                                              Response,   -- TP_AOUT2
                                              Response,   -- TP_AOUT1
                                              Response,   -- TP_AOUT0
                                              Response,   -- TP_BOUT3
                                              Response,   -- TP_BOUT2
                                              Response,   -- TP_BOUT1
                                              Response,   -- TP_BOUT0
                                              Stimulus,   -- TP_DATA_IN3
                                              Stimulus,   -- TP_DATA_IN2
                                              Stimulus,   -- TP_DATA_IN1
                                              Stimulus,   -- TP_DATA_IN0
                                              Stimulus,   -- TP_RAM_EN
                                              Stimulus);  -- TP_CP
      
  function PIN_NAME (PIN : Test_Pins) return String;

end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_A3       => return "A3";
      when TP_A2       => return "A2";
      when TP_A1       => return "A1";
      when TP_A0       => return "A0";
      when TP_B3       => return "B3";
      when TP_B2       => return "B2";
      when TP_B1       => return "B1";
      when TP_B0       => return "B0";
      when TP_AOUT3    => return "AOUT3";
      when TP_AOUT2    => return "AOUT2";
      when TP_AOUT1    => return "AOUT1";
      when TP_AOUT0    => return "AOUT0";
      when TP_BOUT3    => return "BOUT3";
      when TP_BOUT2    => return "BOUT2";
      when TP_BOUT1    => return "BOUT1";
      when TP_BOUT0    => return "BOUT0";
      when TP_DATA_IN3 => return "DATA_IN3";
      when TP_DATA_IN2 => return "DATA_IN2";
      when TP_DATA_IN1 => return "DATA_IN1";
      when TP_DATA_IN0 => return "DATA_IN0";
      when TP_RAM_EN   => return "RAM_EN";
      when TP_CP       => return "CP";
    end case;
  end;

end WAVES_DEVICE;

