--  Filename:        ram_TB.vhd
--
-- Version 2.1
-----------------------------------------------------------------------------
--
library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library AM29C01_PACKAGE;
  use AM29C01_PACKAGE.TYPES.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library RAM;
  use RAM.WAVES_DEVICE.all;
  use RAM.WAVES_OBJECTS.all;
  use RAM.WAVES_UTILITIES.all;
  use RAM.WGENERATOR_ram.all;

entity ram_TB is
  begin
  end ram_TB;

-- ======================================================================

architecture TEST_BENCH of ram_TB is

  component DUT 
    port 
    (
      A       : in  Fourbit;
      B       : in  Fourbit;
      AOUT    : out Fourbit;
      BOUT    : out Fourbit;
      DATA_IN : in  Fourbit;
      RAM_EN  : in  Std_Ulogic;
      CP      : in  Std_Ulogic
    );
  end component;

  for all : DUT use entity RAM.RAM (BEHAVIORAL);

  subtype Test_Pin_Range is Integer range
      Test_Pins'pos(TP_A3) + 1 to Test_Pins'pos(TP_CP) + 1;

  -- Input and Output traffic of DUT
  signal TRAFFIC : Std_Ulogic_Vector(Test_Pin_Range);

  signal A       : Fourbit;
  signal B       : Fourbit;
  signal AOUT    : Fourbit;
  signal BOUT    : Fourbit;
  signal DATA_IN : Fourbit;

  -- Test program options
  constant IN_FILE_NAME        : String := "ram_in.dat";
  constant START_TOLERANCE     : Time   := 2 ns;
  constant END_TOLERANCE       : Time   := 2 ns;
  constant DEFAULT_PERIOD      : Time   := 10 ns;
  constant DEFAULT_UNCERTAINTY : Real   := 0.95;

  -- Comparator options
  signal COMPARE           : Boolean           := TRUE;
  constant HOW_TO_REPORT   : Comparison_Format := DO_ASSERTION;
  constant ASSERTION_LEVEL : Severity_Level    := WARNING;

  -- Signal monitor options
  constant HOW_TO_PRINT  : Output_Format := STANDARD;
  constant OUT_FILE_NAME : String        := "ram_out.dat";

  -- signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) :=
  -- (others.M_VALUE => TRUE);
  signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range);

  -- Connection to WAVES dataset
  signal CONNECT : Waves_Port_List (Test_Pin_Range);

  subtype Compare_Pin_Range is Integer range
      Test_Pins'pos(TP_AOUT3) + 1 to Test_Pins'pos(TP_BOUT0) + 1;

------------------------------------------------------------------------------

begin

  -- Call the waveform generator (i.e., the WAVES dataset)
  process 
  begin
    RAM_TEST(CONNECT, IN_FILE_NAME, DEFAULT_PERIOD, DEFAULT_UNCERTAINTY);
    -- ram_TEST(CONNECT);
    wait;
  end process;

----------------------------------------------------------------------------
  -- Instantiate the Device under test

  A(3) <= TRAFFIC(Test_Pins'Pos(TP_A3) + 1);
  A(2) <= TRAFFIC(Test_Pins'Pos(TP_A2) + 1);
  A(1) <= TRAFFIC(Test_Pins'Pos(TP_A1) + 1);
  A(0) <= TRAFFIC(Test_Pins'Pos(TP_A0) + 1);

  B(3) <= TRAFFIC(Test_Pins'Pos(TP_B3) + 1);
  B(2) <= TRAFFIC(Test_Pins'Pos(TP_B2) + 1);
  B(1) <= TRAFFIC(Test_Pins'Pos(TP_B1) + 1);
  B(0) <= TRAFFIC(Test_Pins'Pos(TP_B0) + 1);

  TRAFFIC(Test_Pins'Pos(TP_AOUT3) + 1) <= AOUT(3);
  TRAFFIC(Test_Pins'Pos(TP_AOUT2) + 1) <= AOUT(2);
  TRAFFIC(Test_Pins'Pos(TP_AOUT1) + 1) <= AOUT(1);
  TRAFFIC(Test_Pins'Pos(TP_AOUT0) + 1) <= AOUT(0);

  TRAFFIC(Test_Pins'Pos(TP_BOUT3) + 1) <= BOUT(3);
  TRAFFIC(Test_Pins'Pos(TP_BOUT2) + 1) <= BOUT(2);
  TRAFFIC(Test_Pins'Pos(TP_BOUT1) + 1) <= BOUT(1);
  TRAFFIC(Test_Pins'Pos(TP_BOUT0) + 1) <= BOUT(0);

  DATA_IN(3) <= TRAFFIC(Test_Pins'Pos(TP_DATA_IN3) + 1);
  DATA_IN(2) <= TRAFFIC(Test_Pins'Pos(TP_DATA_IN2) + 1);
  DATA_IN(1) <= TRAFFIC(Test_Pins'Pos(TP_DATA_IN1) + 1);
  DATA_IN(0) <= TRAFFIC(Test_Pins'Pos(TP_DATA_IN0) + 1);

  UNDER_TEST : DUT
    port map 
    (
      A,
      B,
      AOUT,
      BOUT,
      DATA_IN,
      TRAFFIC(Test_Pins'Pos(TP_RAM_EN) + 1),
      TRAFFIC(Test_Pins'Pos(TP_CP) + 1)
    );

----------------------------------------------------------------------------
  -- Collect all signals (inputs and output of DUT) into signal TRAFFIC

  COLLECT_INPUTS1:
    for I in Test_Pins'pos(TP_A3) + 1 to Test_Pins'pos(TP_B0) + 1 generate
        TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
        (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I)));
  end generate COLLECT_INPUTS1;

  COLLECT_INPUTS2:
    for I in Test_Pins'pos(TP_DATA_IN3) + 1 to Test_Pins'pos(TP_CP) + 1 generate
        TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
        (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I)));
  end generate COLLECT_INPUTS2;

----------------------------------------------------------------------------

  SIGNAL_TRAFFIC : SIGNAL_MONITOR(OUT_FILE_NAME, TRAFFIC, HOW_TO_PRINT);

----------------------------------------------------------------------------

  GEN_COMPARATOR:
    for I in Compare_Pin_Range generate
      COMPARATOR : CHECK_RESPONSE(WHICH_ONE => I,
                                  RESPONSE => TRAFFIC(I),
                                  PREDICTION => CONNECT(I),
                                  COMPARE => COMPARE,
                                  HOW_TO_REPORT => HOW_TO_REPORT,
                                  ASSERTION_LEVEL => ASSERTION_LEVEL,
                                  MATCH => SMATCH(I).M_VALUE);

  end generate GEN_COMPARATOR;

end TEST_BENCH;

