-- Filename : ram.vhd
--
-- Version 2.1
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--
-----------------------------------------------------------------------------
-- DESCRIPTION:             
--
-- This file contains the entity declaration and behavioral model for
-- a 16x4 two-port read single port write ram. It is used as a module for the 
-- Am2901 model. Data is written when both the enable and clock are low. 
-- Data is read when either enable or the clock is high.  During a read 
-- operation in which all or part of the read address is unknown the
-- output port is switched to "XXXX". During a write operation, all RAM locations 
-- that map to the write address will be writen with the data. For example "01X0" 
-- maps to RAM locations "0100" and "0110". If either the enable or clock is
-- unknown the output port is switched to "XXXX"


library STD_PACK;
  use STD_PACK.MISC_FUNC.BITVECTOR_TO_INT;

library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library AM29C01_PACKAGE;
  use AM29C01_PACKAGE.TYPES.all;
  use AM29C01_PACKAGE.FUNCTIONS.all;

entity RAM is
  port
  (
    A       : in  Fourbit;      -- Read Address
    B       : in  Fourbit;      -- Read/Write Address
    AOUT    : out Fourbit;      -- output port for A read Address
    BOUT    : out Fourbit;      -- output port for B read Address
    DATA_IN : in  Fourbit;      -- Data port
    RAM_EN  : in  Std_Ulogic;   -- Active low write enable
    CP      : in  Std_Ulogic);  -- clock
end RAM;

-- ======================================================================

architecture BEHAVIORAL of RAM is

begin

  process(RAM_EN,CP,A,B,DATA_IN)
    variable RAM    : Ram_Array (0 to 15);
    variable ATOINT : Natural;
    variable BTOINT : Natural;

  begin
    case RAM_EN is
      when '0' | 'L' => 
        case CP is
          when '0' | 'L' =>  
            for i in RAM'range loop
              if(MODIFY_RAM(B, I)) then
                RAM(I) := DATA_IN;
              end if;
              
            end loop;         
            
          when '1' | 'H' =>  ATOINT := BITVECTOR_TO_INT(A);
            if(ATOINT >= RAM'low and ATOINT <= RAM'high) then
              AOUT <= RAM(ATOINT);
            else
              AOUT <= "XXXX";    
            end if;    
            
            BTOINT := BITVECTOR_TO_INT(B);
            if(BTOINT >= RAM'low and BTOINT <= RAM'high) then
              BOUT <= RAM(BTOINT);
            else
              BOUT <= "XXXX";    
            end if;    
            
          when others => AOUT <= "XXXX";
                         BOUT <= "XXXX"; 
        end case;

        when '1' | 'H' =>  ATOINT := BITVECTOR_TO_INT(A);
          if (ATOINT >= RAM'low and ATOINT <= RAM'high) then
            AOUT <= RAM(ATOINT);
          else
            AOUT <= "XXXX";    
          end if;    
          
          BTOINT := BITVECTOR_TO_INT(B);
          if (BTOINT >= RAM'low and BTOINT <= RAM'high) then
            BOUT <= RAM(BTOINT);
          else
            BOUT <= "XXXX";    
          end if;    
          
        when others => AOUT <= "XXXX";
                       BOUT <= "XXXX";
    end case;

  end process;
  
end BEHAVIORAL;
    
