-- Filename: waves_device_qreg.vhd
--
-- Version 2.1
-----------------------------------------------------------------------------
--
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is
  type Test_Pins is ( TP_DATA_IN3, TP_DATA_IN2, TP_DATA_IN1, TP_DATA_IN0,
                      TP_DATA_OUT3, TP_DATA_OUT2, TP_DATA_OUT1, TP_DATA_OUT0,
                      TP_CP, TP_QEN);

  constant DEVICE_ID : String := "qreg";

  -- The following declaration is just for documentation purposes.
  constant PIN_DIRECTION : Direction_List := (Stimulus,   -- TP_DATA_IN3
                                              Stimulus,   -- TP_DATA_IN2
                                              Stimulus,   -- TP_DATA_IN1
                                              Stimulus,   -- TP_DATA_IN0
                                              Response,   -- TP_DATA_OUT3
                                              Response,   -- TP_DATA_OUT2
                                              Response,   -- TP_DATA_OUT1
                                              Response,   -- TP_DATA_OUT0
                                              Stimulus,   -- TP_CP
                                              Stimulus);  -- TP_QEN

  function PIN_NAME (PIN : Test_Pins) return String;
        
    
end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_DATA_IN3 => return "DATA_IN3";
      when TP_DATA_IN2 => return "DATA_IN2";
      when TP_DATA_IN1 => return "DATA_IN1";
      when TP_DATA_IN0 => return "DATA_IN0";
      when TP_DATA_OUT3 => return "DATA_OUT3";
      when TP_DATA_OUT2 => return "DATA_OUT2";
      when TP_DATA_OUT1 => return "DATA_OUT1";
      when TP_DATA_OUT0 => return "DATA_OUT0";
      when TP_CP => return "CP";
      when TP_QEN => return "QEN";
    end case;
  end;

end WAVES_DEVICE;

