--  Filename:        qreg_TB.vhd
--
-- Version 2.1
------------------------------------------------------------------------------
--
library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library AM29C01_PACKAGE;
  use AM29C01_PACKAGE.TYPES.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library QREG;
  use QREG.WAVES_DEVICE.all;
  use QREG.WAVES_OBJECTS.all;
  use QREG.WAVES_UTILITIES.all;
  use QREG.WGENERATOR_qreg.all;

entity qreg_TB is
  begin
  end qreg_TB;

-- ======================================================================

architecture TEST_BENCH of qreg_TB is

  component DUT 
    port 
    (
      DATA_IN  : in Fourbit;
      DATA_OUT : out Fourbit;
      CP       : in Std_Ulogic;
      QEN      : in Std_Ulogic
    );
  end component;

  for all : DUT use entity QREG.QREG(BEHAVIORAL);

  subtype Test_Pin_Range is Integer range
      Test_Pins'pos(TP_DATA_IN3) + 1 to Test_Pins'pos(TP_QEN) + 1;

  -- Input and Output traffic of DUT
  signal TRAFFIC : Std_Ulogic_Vector(Test_Pin_Range);

  signal DATA_IN  : Fourbit;
  signal DATA_OUT : Fourbit;

  -- Test program options
  constant IN_FILE_NAME        : String := "qreg_in.dat";
  constant START_TOLERANCE     : Time := 2 ns;
  constant END_TOLERANCE       : Time := 2 ns;
  constant DEFAULT_PERIOD      : Time := 5 ns;
  constant DEFAULT_UNCERTAINTY : Real := 0.95;

  -- Comparator options
  signal COMPARE           : Boolean           := TRUE;
  constant HOW_TO_REPORT   : Comparison_Format := DO_ASSERTION;
  constant ASSERTION_LEVEL : Severity_Level    := WARNING;

  -- Signal monitor options
  constant HOW_TO_PRINT  : Output_Format := STANDARD;
  constant OUT_FILE_NAME : String        := "qreg_out.dat";
   
  --signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) := 
  --(others.M_VALUE => TRUE);
  signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range);

  -- Connection to WAVES dataset
  signal CONNECT : Waves_Port_List (Test_Pin_Range);

  subtype Compare_Pin_Range is Integer range
      Test_Pins'pos(TP_DATA_OUT3) + 1 to Test_Pins'pos(TP_DATA_OUT0) + 1;

------------------------------------------------------------------------------

begin

  -- Call the waveform generator (i.e., the WAVES dataset)
  process
  begin
    -- qreg_TEST(CONNECT, IN_FILE_NAME, START_TOLERANCE, END_TOLERANCE);
    -- qreg_TEST(CONNECT);
    qreg_TEST(CONNECT, IN_FILE_NAME, DEFAULT_PERIOD, DEFAULT_UNCERTAINTY);
    wait;
  end process;

  ----------------------------------------------------------------------------
  -- Instantiate the Device under test

  DATA_IN(3) <= TRAFFIC(Test_Pins'Pos(TP_DATA_IN3) + 1);
  DATA_IN(2) <= TRAFFIC(Test_Pins'Pos(TP_DATA_IN2) + 1);
  DATA_IN(1) <= TRAFFIC(Test_Pins'Pos(TP_DATA_IN1) + 1);
  DATA_IN(0) <= TRAFFIC(Test_Pins'Pos(TP_DATA_IN0) + 1);

  TRAFFIC(Test_Pins'Pos(TP_DATA_OUT3) + 1) <= DATA_OUT(3);
  TRAFFIC(Test_Pins'Pos(TP_DATA_OUT2) + 1) <= DATA_OUT(2);
  TRAFFIC(Test_Pins'Pos(TP_DATA_OUT1) + 1) <= DATA_OUT(1);
  TRAFFIC(Test_Pins'Pos(TP_DATA_OUT0) + 1) <= DATA_OUT(0);

  UNDER_TEST : DUT
  port map 
  (
    DATA_IN,
    DATA_OUT,
    TRAFFIC(Test_Pins'Pos(TP_CP) + 1) ,
    TRAFFIC(Test_Pins'Pos(TP_QEN) + 1)
  );

----------------------------------------------------------------------------
  -- Collect all signals (inputs and output of DUT) into signal TRAFFIC

  COLLECT_INPUTS:
    for I in Test_Pins'pos(TP_DATA_IN3) + 1 to Test_Pins'pos(TP_DATA_IN0)
        + 1 generate TRAFFIC(I) <= 
        LOGIC_VALUE_TO_STD_ULOGIC(WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I)));
  end generate COLLECT_INPUTS;

  TRAFFIC(Test_Pins'pos(TP_CP) + 1) <= LOGIC_VALUE_TO_STD_ULOGIC 
      (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(Test_Pins'pos(TP_CP) + 1)));

  TRAFFIC(Test_Pins'pos(TP_QEN) + 1) <= LOGIC_VALUE_TO_STD_ULOGIC 
      (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(Test_Pins'pos(TP_QEN) + 1)));

----------------------------------------------------------------------------

  SIGNAL_TRAFFIC : SIGNAL_MONITOR(OUT_FILE_NAME, TRAFFIC, HOW_TO_PRINT);

----------------------------------------------------------------------------

  GEN_COMPARATOR:
    for I in Compare_Pin_Range generate
      COMPARATOR : CHECK_RESPONSE(WHICH_ONE => I,RESPONSE => TRAFFIC(I),
                                  PREDICTION => CONNECT(I),
                                  COMPARE => COMPARE,
                                  HOW_TO_REPORT => HOW_TO_REPORT,
                                  ASSERTION_LEVEL => ASSERTION_LEVEL,
                                  MATCH => SMATCH(I).M_VALUE );
  end generate GEN_COMPARATOR;

end TEST_BENCH;

