-- Filename:        waves_device_decoder.vhd
--
-- Version 2.1
--
-----------------------------------------------------------------------------
--
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is
  type Test_Pins is ( TP_SRC2, TP_SRC1, TP_SRC0, 
                      TP_DEST2, TP_DEST1, TP_DEST0, 
                      TP_FUNT2, TP_FUNT1, TP_FUNT0, 
                      TP_RMUX_SEL1, TP_RMUX_SEL0, 
                      TP_SMUX_SEL1, TP_SMUX_SEL0,
                      TP_YMUX_SEL, TP_QMUX_SEL, TP_Q_LOAD, 
                      TP_QSHIFT_DIR, TP_QSHIFT_SEL, TP_RAM_EN, 
                      TP_RAMSHIFT_DIR, TP_RAMSHIFT_SEL,
                      TP_ALU_FUNT2, TP_ALU_FUNT1, TP_ALU_FUNT0);

  constant DEVICE_ID : String := "decoder";

  -- The following declaration is just for documentation purposes.

  constant PIN_DIRECTION : Direction_List := (Stimulus,   -- TP_SRC2
                                              Stimulus,   -- TP_SRC1
                                              Stimulus,   -- TP_SRC0
                                              Stimulus,   -- TP_DEST2
                                              Stimulus,   -- TP_DEST1
                                              Stimulus,   -- TP_DEST0
                                              Stimulus,   -- TP_FUNT2
                                              Stimulus,   -- TP_FUNT1
                                              Stimulus,   -- TP_FUNT0
                                              Response,   -- TP_RMUX_sel1
                                              Response,   -- TP_RMUX_sel0
                                              Response,   -- TP_SMUX_sel1
                                              Response,   -- TP_SMUX_sel0
                                              Response,   -- TP_YMUX_sel
                                              Response,   -- TP_QMUX_sel
                                              Response,   -- TP_Q_load
                                              Response,   -- TP_QSHIFT_dir
                                              Response,   -- TP_QSHIFT_sel
                                              Response,   -- TP_RAM_en
                                              Response,   -- TP_RAMSHIFT_dir
                                              Response,   -- TP_RAMSHIFT_sel
                                              Response,   -- TP_ALU_FUNT2
                                              Response,   -- TP_ALU_FUNT1
                                              Response);  -- TP_ALU_FUNT0
        
  function PIN_NAME (PIN : Test_Pins) return String;

end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_SRC2 => return "SRC2";
      when TP_SRC1 => return "SRC1";
      when TP_SRC0 => return "SRC0";
      when TP_DEST2 => return "DEST2";
      when TP_DEST1 => return "DEST1";
      when TP_DEST0 => return "DEST0";
      when TP_FUNT2 => return "FUNT2";
      when TP_FUNT1 => return "FUNT1"; 
      when TP_FUNT0 => return "FUNT0";
      when TP_RMUX_SEL1 => return "RMUX_SEL1";
      when TP_RMUX_SEL0 => return "RMUX_SEL0";
      when TP_SMUX_SEL1 => return "SMUX_SEL1";
      when TP_SMUX_SEL0 => return "SMUX_SEL0";
      when TP_YMUX_SEL => return "YMUX_SEL";
      when TP_QMUX_SEL => return "QMUX_SEL";
      when TP_Q_LOAD => return "Q_LOAD";
      when TP_QSHIFT_DIR => return "QSHIFT_DIR";
      when TP_QSHIFT_SEL => return "QSHIFT_SEL";
      when TP_RAM_EN => return "RAM_EN";
      when TP_RAMSHIFT_DIR => return "RAMSHIFT_DIR";
      when TP_RAMSHIFT_SEL => return "RAMSHIFT_SEL";
      when TP_ALU_FUNT2 => return "ALU_FUNT2";
      when TP_ALU_FUNT1 => return "ALU_FUNT1";
      when TP_ALU_FUNT0 => return "ALU_FUNT0";
    end case;
  end;

end WAVES_DEVICE;

