--  Filename:        Decoder_TB.vhd
--
-- Version 2.1
--
-----------------------------------------------------------------------------

library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library AM29C01_PACKAGE;
  use AM29C01_PACKAGE.TYPES.all;
  use AM29C01_PACKAGE.FUNCTIONS.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library DECODER;
  use DECODER.WAVES_DEVICE.all;
  use DECODER.WAVES_OBJECTS.all;
  use DECODER.WAVES_UTILITIES.all;
  use DECODER.WGENERATOR_Decoder.all;

entity Decoder_TB is

  begin
  
  end Decoder_TB;

-- ======================================================================

architecture TEST_BENCH of Decoder_TB is

  component DUT 
    port 
    (
      SRC          : in  Threebit;
      DEST         : in  Threebit;
      FUNT         : in  Threebit;
      RMUX_SEL     : out Twobit;
      SMUX_SEL     : out Twobit;
      YMUX_SEL     : out Std_Ulogic;
      QMUX_SEL     : out Std_Ulogic;
      Q_LOAD       : out Std_Ulogic;
      QSHIFT_DIR   : out Std_Ulogic;
      QSHIFT_SEL   : out Std_Ulogic;
      RAM_EN       : out Std_Ulogic;
      RAMSHIFT_DIR : out Std_Ulogic;
      RAMSHIFT_SEL : out Std_Ulogic;
      ALU_FUNT     : out Threebit
    );
  end component;

  for all : DUT use entity DECODER.DECODER(BEHAVIORAL);

  subtype Test_Pin_Range is integer range
      Test_Pins'pos(TP_SRC2) + 1 to Test_Pins'pos(TP_ALU_FUNT0) + 1;

  -- Input and Output traffic of DUT
  signal TRAFFIC : Std_Ulogic_Vector(Test_Pin_Range);

  signal SRC      : Threebit;
  signal DEST     : Threebit;
  signal FUNT     : Threebit;
  signal RMUX_SEL : Twobit;
  signal SMUX_SEL : Twobit;
  signal ALU_FUNT : Threebit;

  -- Test program options
  constant IN_FILE_NAME    : String := "decoder_in.dat";
  constant PERIOD          : Time   := 10 ns;
  constant UNCERTAINTY     : Real   := 0.95;
  constant START_TOLERANCE : Time   := 2 ns;
  constant END_TOLERANCE   : Time   := 2 ns;

  -- Comparator options
  signal COMPARE           : Boolean           := TRUE;
  constant HOW_TO_REPORT   : Comparison_Format := DO_ASSERTION;
  constant ASSERTION_LEVEL : Severity_Level    := WARNING;

  -- Signal monitor options
  constant HOW_TO_PRINT  : Output_Format := STANDARD;
  constant OUT_FILE_NAME : String        := "decoder_out.dat";

  signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range);

  -- Connection to WAVES dataset
  signal CONNECT : Waves_Port_List (Test_Pin_Range);

  subtype Compare_Pin_Range is Integer range
      Test_Pins'pos(TP_RMUX_SEL1) + 1 to Test_Pins'pos(TP_ALU_FUNT0) + 1;

------------------------------------------------------------------------------

begin

  -- Call the waveform generator (i.e., the WAVES dataset)
  process begin
--  Decoder_TEST(CONNECT, IN_FILE_NAME, START_TOLERANCE, END_TOLERANCE);
    Decoder_TEST(CONNECT, IN_FILE_NAME, PERIOD, UNCERTAINTY);
--  Decoder_TEST(CONNECT);
    wait;
  end process;

----------------------------------------------------------------------------
  -- Instantiate the Device under test

  SRC(2) <= TRAFFIC(Test_Pins'Pos(TP_SRC2) + 1);
  SRC(1) <= TRAFFIC(Test_Pins'Pos(TP_SRC1) + 1);    
  SRC(0) <= TRAFFIC(Test_Pins'Pos(TP_SRC0) + 1);

  DEST(2) <= TRAFFIC(Test_Pins'Pos(TP_DEST2) + 1);
  DEST(1) <= TRAFFIC(Test_Pins'Pos(TP_DEST1) + 1);    
  DEST(0) <= TRAFFIC(Test_Pins'Pos(TP_DEST0) + 1);

  FUNT(2) <= TRAFFIC(Test_Pins'Pos(TP_FUNT2) + 1);
  FUNT(1) <= TRAFFIC(Test_Pins'Pos(TP_FUNT1) + 1);    
  FUNT(0) <= TRAFFIC(Test_Pins'Pos(TP_FUNT0) + 1);

  TRAFFIC(Test_Pins'Pos(TP_RMUX_SEL1) + 1) <= RMUX_SEL(1);    
  TRAFFIC(Test_Pins'Pos(TP_RMUX_SEL0) + 1) <= RMUX_SEL(0);

  TRAFFIC(Test_Pins'Pos(TP_SMUX_SEL1) + 1) <= SMUX_SEL(1);    
  TRAFFIC(Test_Pins'Pos(TP_SMUX_SEL0) + 1) <= SMUX_SEL(0);

  TRAFFIC(Test_Pins'Pos(TP_ALU_FUNT2) + 1) <= ALU_FUNT(2);    
  TRAFFIC(Test_Pins'Pos(TP_ALU_FUNT1) + 1) <= ALU_FUNT(1);    
  TRAFFIC(Test_Pins'Pos(TP_ALU_FUNT0) + 1) <= ALU_FUNT(0);

  UNDER_TEST : DUT
    port map 
    (
      SRC,
      DEST,
      FUNT,
      RMUX_SEL,
      SMUX_SEL,
      TRAFFIC(Test_Pins'Pos(TP_YMUX_SEL) + 1),
      TRAFFIC(Test_Pins'Pos(TP_QMUX_SEL) + 1),
      TRAFFIC(Test_Pins'Pos(TP_Q_LOAD) + 1),
      TRAFFIC(Test_Pins'Pos(TP_QSHIFT_DIR) + 1),
      TRAFFIC(Test_Pins'Pos(TP_QSHIFT_SEL) + 1),
      TRAFFIC(Test_Pins'Pos(TP_RAM_EN) + 1),
      TRAFFIC(Test_Pins'Pos(TP_RAMSHIFT_DIR) + 1),
      TRAFFIC(Test_Pins'Pos(TP_RAMSHIFT_SEL) + 1),
      ALU_FUNT
    );

----------------------------------------------------------------------------
  -- Collect all signals (inputs and output of DUT) into signal TRAFFIC

  COLLECT_INPUTS:
    for I in Test_Pins'pos(TP_SRC2) + 1 to Test_Pins'pos(TP_FUNT0) 
        + 1 generate TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
        (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I)));
  end generate COLLECT_INPUTS;

----------------------------------------------------------------------------

  SIGNAL_TRAFFIC : SIGNAL_MONITOR(OUT_FILE_NAME, TRAFFIC, HOW_TO_PRINT);

----------------------------------------------------------------------------

  GEN_COMPARATOR:
    for I in Compare_Pin_Range generate
      COMPARATOR : CHECK_RESPONSE(WHICH_ONE => I, 
                                  RESPONSE => TRAFFIC(I),
                                  PREDICTION => CONNECT(I),
                                  COMPARE => COMPARE,
                                  HOW_TO_REPORT => HOW_TO_REPORT,
                                  ASSERTION_LEVEL => ASSERTION_LEVEL,
                                  MATCH => SMATCH(I).M_VALUE );

  end generate GEN_COMPARATOR;

end TEST_BENCH;

